@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Information for connecting to SQL database server
 * @property additionalSettings Additional connection settings
 * @property authentication Authentication type to use for connection
 * @property dataSource Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property platform Server platform type for connection
 * @property trustServerCertificate Whether to trust the server certificate
 * @property type Type of connection info
 * Expected value is 'SqlConnectionInfo'.
 * @property userName User name
 */
public data class SqlConnectionInfoResponse(
    public val additionalSettings: String? = null,
    public val authentication: String? = null,
    public val dataSource: String,
    public val encryptConnection: Boolean? = null,
    public val password: String? = null,
    public val platform: String? = null,
    public val trustServerCertificate: Boolean? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SqlConnectionInfoResponse):
            SqlConnectionInfoResponse = SqlConnectionInfoResponse(
            additionalSettings = javaType.additionalSettings().map({ args0 -> args0 }).orElse(null),
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            dataSource = javaType.dataSource(),
            encryptConnection = javaType.encryptConnection().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().map({ args0 -> args0 }).orElse(null),
            trustServerCertificate = javaType.trustServerCertificate().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
