@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Source SQL Connection
 * @property authentication Authentication type.
 * @property dataSource Data source.
 * @property encryptConnection Whether to encrypt connection or not.
 * @property password Password to connect to source SQL.
 * @property trustServerCertificate Whether to trust server certificate or not.
 * @property userName User name to connect to source SQL.
 */
public data class SqlConnectionInformationResponse(
    public val authentication: String? = null,
    public val dataSource: String? = null,
    public val encryptConnection: Boolean? = null,
    public val password: String? = null,
    public val trustServerCertificate: Boolean? = null,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SqlConnectionInformationResponse):
            SqlConnectionInformationResponse = SqlConnectionInformationResponse(
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            dataSource = javaType.dataSource().map({ args0 -> args0 }).orElse(null),
            encryptConnection = javaType.encryptConnection().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            trustServerCertificate = javaType.trustServerCertificate().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
