@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance online scenario.
 * @property azureApp Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
 * @property backupFileShare Backup file share information for all selected databases.
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source SQL Server
 * @property storageResourceId Fully qualified resourceId of storage
 * @property targetConnectionInfo Connection information for Azure SQL Database Managed Instance
 */
public data class ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse(
    public val azureApp: AzureActiveDirectoryAppResponse,
    public val backupFileShare: FileShareResponse? = null,
    public val selectedDatabases: List<MigrateSqlServerSqlMIDatabaseInputResponse>,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val storageResourceId: String,
    public val targetConnectionInfo: MiSqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse):
            ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse =
            ValidateMigrationInputSqlServerSqlMISyncTaskInputResponse(
                azureApp = javaType.azureApp().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.AzureActiveDirectoryAppResponse.Companion.toKotlin(args0)
                }),
                backupFileShare = javaType.backupFileShare().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.FileShareResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSqlServerSqlMIDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                storageResourceId = javaType.storageResourceId(),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MiSqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
