@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties for task that validates migration input for SQL to Azure SQL Database Managed Instance
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property commands Array of command properties.
 * @property errors Array of errors. This is ignored if submitted.
 * @property input Task input
 * @property output Task output. This is ignored if submitted.
 * @property state The state of the task. This is ignored if submitted.
 * @property taskType Task type.
 * Expected value is 'ValidateMigrationInput.SqlServer.AzureSqlDbMI'.
 */
public data class ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse(
    public val clientData: Map<String, String>? = null,
    public val commands:
    List<Either<MigrateMISyncCompleteCommandPropertiesResponse, MigrateSyncCompleteCommandPropertiesResponse>>,
    public val errors: List<ODataErrorResponse>,
    public val input: ValidateMigrationInputSqlServerSqlMITaskInputResponse? = null,
    public val output: List<ValidateMigrationInputSqlServerSqlMITaskOutputResponse>,
    public val state: String,
    public val taskType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse):
            ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse =
            ValidateMigrationInputSqlServerSqlMITaskPropertiesResponse(
                clientData = javaType.clientData().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                commands = javaType.commands().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateMISyncCompleteCommandPropertiesResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSyncCompleteCommandPropertiesResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                errors = javaType.errors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ODataErrorResponse.Companion.toKotlin(args0)
                    })
                }),
                input = javaType.input().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                output = javaType.output().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse.Companion.toKotlin(args0)
                    })
                }),
                state = javaType.state(),
                taskType = javaType.taskType(),
            )
    }
}
