@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupVaultResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.DppIdentityDetailsResponse
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupVaultResponse.Companion.toKotlin as backupVaultResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.DppIdentityDetailsResponse.Companion.toKotlin as dppIdentityDetailsResponseToKotlin
import com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BackupVault].
 */
@PulumiTagMarker
public class BackupVaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupVaultArgs = BackupVaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupVaultArgsBuilder.() -> Unit) {
        val builder = BackupVaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupVault {
        val builtJavaResource =
            com.pulumi.azurenative.dataprotection.BackupVault(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupVault(builtJavaResource)
    }
}

/**
 * Backup Vault Resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### Create BackupVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupVault = new AzureNative.DataProtection.BackupVault("backupVault", new()
 *     {
 *         Identity = new AzureNative.DataProtection.Inputs.DppIdentityDetailsArgs
 *         {
 *             Type = "None",
 *         },
 *         Location = "WestUS",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupVaultArgs
 *         {
 *             MonitoringSettings = new AzureNative.DataProtection.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.DataProtection.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = "Enabled",
 *                 },
 *             },
 *             StorageSettings = new[]
 *             {
 *                 new AzureNative.DataProtection.Inputs.StorageSettingArgs
 *                 {
 *                     DatastoreType = "VaultStore",
 *                     Type = "LocallyRedundant",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupVault(ctx, "backupVault", &dataprotection.BackupVaultArgs{
 * Identity: &dataprotection.DppIdentityDetailsArgs{
 * Type: pulumi.String("None"),
 * },
 * Location: pulumi.String("WestUS"),
 * Properties: dataprotection.BackupVaultResponse{
 * MonitoringSettings: interface{}{
 * AzureMonitorAlertSettings: &dataprotection.AzureMonitorAlertSettingsArgs{
 * AlertsForAllJobFailures: pulumi.String("Enabled"),
 * },
 * },
 * StorageSettings: dataprotection.StorageSettingArray{
 * &dataprotection.StorageSettingArgs{
 * DatastoreType: pulumi.String("VaultStore"),
 * Type: pulumi.String("LocallyRedundant"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("swaggerExample"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupVault;
 * import com.pulumi.azurenative.dataprotection.BackupVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupVault = new BackupVault("backupVault", BackupVaultArgs.builder()
 *             .identity(Map.of("type", "None"))
 *             .location("WestUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoringSettings", Map.of("azureMonitorAlertSettings", Map.of("alertsForAllJobFailures", "Enabled"))),
 *                 Map.entry("storageSettings", Map.ofEntries(
 *                     Map.entry("datastoreType", "VaultStore"),
 *                     Map.entry("type", "LocallyRedundant")
 *                 ))
 *             ))
 *             .resourceGroupName("SampleResourceGroup")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### Create BackupVault With MSI
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupVault = new AzureNative.DataProtection.BackupVault("backupVault", new()
 *     {
 *         Identity = new AzureNative.DataProtection.Inputs.DppIdentityDetailsArgs
 *         {
 *             Type = "systemAssigned",
 *         },
 *         Location = "WestUS",
 *         Properties = new AzureNative.DataProtection.Inputs.BackupVaultArgs
 *         {
 *             MonitoringSettings = new AzureNative.DataProtection.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.DataProtection.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = "Enabled",
 *                 },
 *             },
 *             StorageSettings = new[]
 *             {
 *                 new AzureNative.DataProtection.Inputs.StorageSettingArgs
 *                 {
 *                     DatastoreType = "VaultStore",
 *                     Type = "LocallyRedundant",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := dataprotection.NewBackupVault(ctx, "backupVault", &dataprotection.BackupVaultArgs{
 * Identity: &dataprotection.DppIdentityDetailsArgs{
 * Type: pulumi.String("systemAssigned"),
 * },
 * Location: pulumi.String("WestUS"),
 * Properties: dataprotection.BackupVaultResponse{
 * MonitoringSettings: interface{}{
 * AzureMonitorAlertSettings: &dataprotection.AzureMonitorAlertSettingsArgs{
 * AlertsForAllJobFailures: pulumi.String("Enabled"),
 * },
 * },
 * StorageSettings: dataprotection.StorageSettingArray{
 * &dataprotection.StorageSettingArgs{
 * DatastoreType: pulumi.String("VaultStore"),
 * Type: pulumi.String("LocallyRedundant"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("val1"),
 * },
 * VaultName: pulumi.String("swaggerExample"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.BackupVault;
 * import com.pulumi.azurenative.dataprotection.BackupVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupVault = new BackupVault("backupVault", BackupVaultArgs.builder()
 *             .identity(Map.of("type", "systemAssigned"))
 *             .location("WestUS")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoringSettings", Map.of("azureMonitorAlertSettings", Map.of("alertsForAllJobFailures", "Enabled"))),
 *                 Map.entry("storageSettings", Map.ofEntries(
 *                     Map.entry("datastoreType", "VaultStore"),
 *                     Map.entry("type", "LocallyRedundant")
 *                 ))
 *             ))
 *             .resourceGroupName("SampleResourceGroup")
 *             .tags(Map.of("key1", "val1"))
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:BackupVault swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}
 * ```
 */
public class BackupVault internal constructor(
    override val javaResource: com.pulumi.azurenative.dataprotection.BackupVault,
) : KotlinCustomResource(javaResource, BackupVaultMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Input Managed Identity Details
     */
    public val identity: Output<DppIdentityDetailsResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dppIdentityDetailsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * BackupVaultResource properties
     */
    public val properties: Output<BackupVaultResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                backupVaultResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BackupVaultMapper : ResourceMapper<BackupVault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dataprotection.BackupVault::class == javaResource::class

    override fun map(javaResource: Resource): BackupVault = BackupVault(
        javaResource as
            com.pulumi.azurenative.dataprotection.BackupVault,
    )
}

/**
 * @see [BackupVault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupVault].
 */
public suspend fun backupVault(name: String, block: suspend BackupVaultResourceBuilder.() -> Unit):
    BackupVault {
    val builder = BackupVaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupVault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupVault(name: String): BackupVault {
    val builder = BackupVaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
