@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AbsoluteDeleteOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Delete option with duration
 * @property duration Duration of deletion after given timespan
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AbsoluteDeleteOption'.
 */
public data class AbsoluteDeleteOptionArgs(
    public val duration: Output<String>,
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AbsoluteDeleteOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AbsoluteDeleteOptionArgs =
        com.pulumi.azurenative.dataprotection.inputs.AbsoluteDeleteOptionArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AbsoluteDeleteOptionArgs].
 */
@PulumiTagMarker
public class AbsoluteDeleteOptionArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value Duration of deletion after given timespan
     */
    @JvmName("nyjpqucspmbtkdnw")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AbsoluteDeleteOption'.
     */
    @JvmName("lkdjwqdwgsfrxnxx")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Duration of deletion after given timespan
     */
    @JvmName("snpxeojaqyfkultv")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AbsoluteDeleteOption'.
     */
    @JvmName("dnuvkubrhhirsngr")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): AbsoluteDeleteOptionArgs = AbsoluteDeleteOptionArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
