@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTriggerContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Adhoc trigger context
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AdhocBasedTriggerContext'.
 * @property taggingCriteria Tagging Criteria containing retention tag for adhoc backup.
 */
public data class AdhocBasedTriggerContextArgs(
    public val objectType: Output<String>,
    public val taggingCriteria: Output<AdhocBasedTaggingCriteriaArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTriggerContextArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTriggerContextArgs =
        com.pulumi.azurenative.dataprotection.inputs.AdhocBasedTriggerContextArgs.builder()
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .taggingCriteria(
                taggingCriteria.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AdhocBasedTriggerContextArgs].
 */
@PulumiTagMarker
public class AdhocBasedTriggerContextArgsBuilder internal constructor() {
    private var objectType: Output<String>? = null

    private var taggingCriteria: Output<AdhocBasedTaggingCriteriaArgs>? = null

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AdhocBasedTriggerContext'.
     */
    @JvmName("ancopwvykkcvuvot")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Tagging Criteria containing retention tag for adhoc backup.
     */
    @JvmName("swaoywopluopuqmm")
    public suspend fun taggingCriteria(`value`: Output<AdhocBasedTaggingCriteriaArgs>) {
        this.taggingCriteria = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AdhocBasedTriggerContext'.
     */
    @JvmName("upqlafdptabiyjav")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Tagging Criteria containing retention tag for adhoc backup.
     */
    @JvmName("hdulufxyefqhxcwx")
    public suspend fun taggingCriteria(`value`: AdhocBasedTaggingCriteriaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggingCriteria = mapped
    }

    /**
     * @param argument Tagging Criteria containing retention tag for adhoc backup.
     */
    @JvmName("ooobmgbmspttedjl")
    public suspend
    fun taggingCriteria(argument: suspend AdhocBasedTaggingCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = AdhocBasedTaggingCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.taggingCriteria = mapped
    }

    internal fun build(): AdhocBasedTriggerContextArgs = AdhocBasedTriggerContextArgs(
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        taggingCriteria = taggingCriteria ?: throw PulumiNullFieldException("taggingCriteria"),
    )
}
