@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AzureBackupParamsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure backup parameters
 * @property backupType BackupType ; Full/Incremental etc
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AzureBackupParams'.
 */
public data class AzureBackupParamsArgs(
    public val backupType: Output<String>,
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AzureBackupParamsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AzureBackupParamsArgs =
        com.pulumi.azurenative.dataprotection.inputs.AzureBackupParamsArgs.builder()
            .backupType(backupType.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBackupParamsArgs].
 */
@PulumiTagMarker
public class AzureBackupParamsArgsBuilder internal constructor() {
    private var backupType: Output<String>? = null

    private var objectType: Output<String>? = null

    /**
     * @param value BackupType ; Full/Incremental etc
     */
    @JvmName("xeuowsixoellrfpi")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AzureBackupParams'.
     */
    @JvmName("vrujlylniphrokwx")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value BackupType ; Full/Incremental etc
     */
    @JvmName("iwpkemiqhorhhawb")
    public suspend fun backupType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AzureBackupParams'.
     */
    @JvmName("yxwdhqixrrsixoac")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): AzureBackupParamsArgs = AzureBackupParamsArgs(
        backupType = backupType ?: throw PulumiNullFieldException("backupType"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
