@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.BackupVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Backup Vault
 * @property featureSettings Feature Settings
 * @property monitoringSettings Monitoring Settings
 * @property securitySettings Security Settings
 * @property storageSettings Storage Settings
 */
public data class BackupVaultArgs(
    public val featureSettings: Output<FeatureSettingsArgs>? = null,
    public val monitoringSettings: Output<MonitoringSettingsArgs>? = null,
    public val securitySettings: Output<SecuritySettingsArgs>? = null,
    public val storageSettings: Output<List<StorageSettingArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.BackupVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.BackupVaultArgs =
        com.pulumi.azurenative.dataprotection.inputs.BackupVaultArgs.builder()
            .featureSettings(featureSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitoringSettings(
                monitoringSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securitySettings(securitySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageSettings(
                storageSettings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BackupVaultArgs].
 */
@PulumiTagMarker
public class BackupVaultArgsBuilder internal constructor() {
    private var featureSettings: Output<FeatureSettingsArgs>? = null

    private var monitoringSettings: Output<MonitoringSettingsArgs>? = null

    private var securitySettings: Output<SecuritySettingsArgs>? = null

    private var storageSettings: Output<List<StorageSettingArgs>>? = null

    /**
     * @param value Feature Settings
     */
    @JvmName("jdotsmilkonnbwni")
    public suspend fun featureSettings(`value`: Output<FeatureSettingsArgs>) {
        this.featureSettings = value
    }

    /**
     * @param value Monitoring Settings
     */
    @JvmName("aivgrgafykrnroyh")
    public suspend fun monitoringSettings(`value`: Output<MonitoringSettingsArgs>) {
        this.monitoringSettings = value
    }

    /**
     * @param value Security Settings
     */
    @JvmName("wpofctlvofnihlbw")
    public suspend fun securitySettings(`value`: Output<SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value Storage Settings
     */
    @JvmName("tkomconilrpbnthm")
    public suspend fun storageSettings(`value`: Output<List<StorageSettingArgs>>) {
        this.storageSettings = value
    }

    @JvmName("gjgxoukuhspwlyvy")
    public suspend fun storageSettings(vararg values: Output<StorageSettingArgs>) {
        this.storageSettings = Output.all(values.asList())
    }

    /**
     * @param values Storage Settings
     */
    @JvmName("pjqbfuktdeitugvu")
    public suspend fun storageSettings(values: List<Output<StorageSettingArgs>>) {
        this.storageSettings = Output.all(values)
    }

    /**
     * @param value Feature Settings
     */
    @JvmName("rkmttipusktspict")
    public suspend fun featureSettings(`value`: FeatureSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureSettings = mapped
    }

    /**
     * @param argument Feature Settings
     */
    @JvmName("xulkenaaqbbsmoic")
    public suspend fun featureSettings(argument: suspend FeatureSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.featureSettings = mapped
    }

    /**
     * @param value Monitoring Settings
     */
    @JvmName("qvmvdymmdtiwjbut")
    public suspend fun monitoringSettings(`value`: MonitoringSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringSettings = mapped
    }

    /**
     * @param argument Monitoring Settings
     */
    @JvmName("dquelkveelvrhrqr")
    public suspend
    fun monitoringSettings(argument: suspend MonitoringSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitoringSettings = mapped
    }

    /**
     * @param value Security Settings
     */
    @JvmName("ggtwlhothgpmpync")
    public suspend fun securitySettings(`value`: SecuritySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument Security Settings
     */
    @JvmName("appddmcnlscjgqev")
    public suspend fun securitySettings(argument: suspend SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value Storage Settings
     */
    @JvmName("hsyvpywabnxspfnc")
    public suspend fun storageSettings(`value`: List<StorageSettingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageSettings = mapped
    }

    /**
     * @param argument Storage Settings
     */
    @JvmName("xlkrseegtxderxvk")
    public suspend fun storageSettings(argument: List<suspend StorageSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageSettings = mapped
    }

    /**
     * @param argument Storage Settings
     */
    @JvmName("bekcoyrwxxfrjpvx")
    public suspend fun storageSettings(
        vararg
        argument: suspend StorageSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageSettings = mapped
    }

    /**
     * @param argument Storage Settings
     */
    @JvmName("wvqqckrshgsqlruv")
    public suspend fun storageSettings(argument: suspend StorageSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageSettings = mapped
    }

    /**
     * @param values Storage Settings
     */
    @JvmName("jxxyyirjahhcfwvf")
    public suspend fun storageSettings(vararg values: StorageSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageSettings = mapped
    }

    internal fun build(): BackupVaultArgs = BackupVaultArgs(
        featureSettings = featureSettings,
        monitoringSettings = monitoringSettings,
        securitySettings = securitySettings,
        storageSettings = storageSettings ?: throw PulumiNullFieldException("storageSettings"),
    )
}
