@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.CrossSubscriptionRestoreSettingsArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.CrossSubscriptionRestoreState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CrossSubscriptionRestore Settings
 * @property state CrossSubscriptionRestore state
 */
public data class CrossSubscriptionRestoreSettingsArgs(
    public val state: Output<Either<String, CrossSubscriptionRestoreState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.CrossSubscriptionRestoreSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.dataprotection.inputs.CrossSubscriptionRestoreSettingsArgs =
        com.pulumi.azurenative.dataprotection.inputs.CrossSubscriptionRestoreSettingsArgs.builder()
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CrossSubscriptionRestoreSettingsArgs].
 */
@PulumiTagMarker
public class CrossSubscriptionRestoreSettingsArgsBuilder internal constructor() {
    private var state: Output<Either<String, CrossSubscriptionRestoreState>>? = null

    /**
     * @param value CrossSubscriptionRestore state
     */
    @JvmName("qxnorwqmhbpghvgu")
    public suspend fun state(`value`: Output<Either<String, CrossSubscriptionRestoreState>>) {
        this.state = value
    }

    /**
     * @param value CrossSubscriptionRestore state
     */
    @JvmName("yahksygiqwmjkjlg")
    public suspend fun state(`value`: Either<String, CrossSubscriptionRestoreState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value CrossSubscriptionRestore state
     */
    @JvmName("mubegjictidfettg")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CrossSubscriptionRestoreState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value CrossSubscriptionRestore state
     */
    @JvmName("ofhjuwoukqrksxix")
    public fun state(`value`: CrossSubscriptionRestoreState) {
        val toBeMapped = Either.ofRight<String, CrossSubscriptionRestoreState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): CrossSubscriptionRestoreSettingsArgs = CrossSubscriptionRestoreSettingsArgs(
        state = state,
    )
}
