@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.GetBackupPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backupPolicyName
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The name of the backup vault.
 */
public data class GetBackupPolicyPlainArgs(
    public val backupPolicyName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.GetBackupPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.GetBackupPolicyPlainArgs =
        com.pulumi.azurenative.dataprotection.inputs.GetBackupPolicyPlainArgs.builder()
            .backupPolicyName(backupPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPolicyPlainArgsBuilder internal constructor() {
    private var backupPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value
     */
    @JvmName("qqfrdgsisjvnrdar")
    public suspend fun backupPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fibsexkgyclmmqcm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("dfrsxhracvpvjpuj")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetBackupPolicyPlainArgs = GetBackupPolicyPlainArgs(
        backupPolicyName = backupPolicyName ?: throw PulumiNullFieldException("backupPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
