@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.GetResourceGuardPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceGuardsName The name of ResourceGuard
 */
public data class GetResourceGuardPlainArgs(
    public val resourceGroupName: String,
    public val resourceGuardsName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.GetResourceGuardPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.GetResourceGuardPlainArgs =
        com.pulumi.azurenative.dataprotection.inputs.GetResourceGuardPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceGuardsName(resourceGuardsName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceGuardPlainArgs].
 */
@PulumiTagMarker
public class GetResourceGuardPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceGuardsName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ylnlppjuforhjudh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of ResourceGuard
     */
    @JvmName("ktxnkannxbtrpviq")
    public suspend fun resourceGuardsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGuardsName = mapped
    }

    internal fun build(): GetResourceGuardPlainArgs = GetResourceGuardPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceGuardsName = resourceGuardsName ?: throw PulumiNullFieldException("resourceGuardsName"),
    )
}
