@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.ImmediateCopyOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Immediate copy Option
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ImmediateCopyOption'.
 */
public data class ImmediateCopyOptionArgs(
    public val objectType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.ImmediateCopyOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.ImmediateCopyOptionArgs =
        com.pulumi.azurenative.dataprotection.inputs.ImmediateCopyOptionArgs.builder()
            .objectType(objectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImmediateCopyOptionArgs].
 */
@PulumiTagMarker
public class ImmediateCopyOptionArgsBuilder internal constructor() {
    private var objectType: Output<String>? = null

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ImmediateCopyOption'.
     */
    @JvmName("jgnbpdyavyuovyqg")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'ImmediateCopyOption'.
     */
    @JvmName("juuhbgsanpafndxt")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    internal fun build(): ImmediateCopyOptionArgs = ImmediateCopyOptionArgs(
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
    )
}
