@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.SourceLifeCycleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Source LifeCycle
 * @property deleteAfter Delete Option
 * @property sourceDataStore DataStoreInfo base
 * @property targetDataStoreCopySettings
 */
public data class SourceLifeCycleArgs(
    public val deleteAfter: Output<AbsoluteDeleteOptionArgs>,
    public val sourceDataStore: Output<DataStoreInfoBaseArgs>,
    public val targetDataStoreCopySettings: Output<List<TargetCopySettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.SourceLifeCycleArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.SourceLifeCycleArgs =
        com.pulumi.azurenative.dataprotection.inputs.SourceLifeCycleArgs.builder()
            .deleteAfter(deleteAfter.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceDataStore(sourceDataStore.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetDataStoreCopySettings(
                targetDataStoreCopySettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SourceLifeCycleArgs].
 */
@PulumiTagMarker
public class SourceLifeCycleArgsBuilder internal constructor() {
    private var deleteAfter: Output<AbsoluteDeleteOptionArgs>? = null

    private var sourceDataStore: Output<DataStoreInfoBaseArgs>? = null

    private var targetDataStoreCopySettings: Output<List<TargetCopySettingArgs>>? = null

    /**
     * @param value Delete Option
     */
    @JvmName("siwmbhqmmnstrjre")
    public suspend fun deleteAfter(`value`: Output<AbsoluteDeleteOptionArgs>) {
        this.deleteAfter = value
    }

    /**
     * @param value DataStoreInfo base
     */
    @JvmName("nmgjsxofsjgyesuf")
    public suspend fun sourceDataStore(`value`: Output<DataStoreInfoBaseArgs>) {
        this.sourceDataStore = value
    }

    /**
     * @param value
     */
    @JvmName("flmntxuiwtijnorl")
    public suspend fun targetDataStoreCopySettings(`value`: Output<List<TargetCopySettingArgs>>) {
        this.targetDataStoreCopySettings = value
    }

    @JvmName("arjuntwhpcefhrdn")
    public suspend fun targetDataStoreCopySettings(vararg values: Output<TargetCopySettingArgs>) {
        this.targetDataStoreCopySettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iopymivqfpdsfumi")
    public suspend fun targetDataStoreCopySettings(values: List<Output<TargetCopySettingArgs>>) {
        this.targetDataStoreCopySettings = Output.all(values)
    }

    /**
     * @param value Delete Option
     */
    @JvmName("kpplmrormbuvafad")
    public suspend fun deleteAfter(`value`: AbsoluteDeleteOptionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteAfter = mapped
    }

    /**
     * @param argument Delete Option
     */
    @JvmName("gockvltbrgskorhg")
    public suspend fun deleteAfter(argument: suspend AbsoluteDeleteOptionArgsBuilder.() -> Unit) {
        val toBeMapped = AbsoluteDeleteOptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deleteAfter = mapped
    }

    /**
     * @param value DataStoreInfo base
     */
    @JvmName("gyhwtkhcmdeikdgi")
    public suspend fun sourceDataStore(`value`: DataStoreInfoBaseArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceDataStore = mapped
    }

    /**
     * @param argument DataStoreInfo base
     */
    @JvmName("weqvlqhgddpeptjo")
    public suspend fun sourceDataStore(argument: suspend DataStoreInfoBaseArgsBuilder.() -> Unit) {
        val toBeMapped = DataStoreInfoBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceDataStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptplybkivpmoqcbv")
    public suspend fun targetDataStoreCopySettings(`value`: List<TargetCopySettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDataStoreCopySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bablpsguspeyoubc")
    public suspend
    fun targetDataStoreCopySettings(argument: List<suspend TargetCopySettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetCopySettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetDataStoreCopySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("slosduvpdoogyhjo")
    public suspend fun targetDataStoreCopySettings(
        vararg
        argument: suspend TargetCopySettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TargetCopySettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetDataStoreCopySettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("abojqvnwfwegijhj")
    public suspend
    fun targetDataStoreCopySettings(argument: suspend TargetCopySettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetCopySettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetDataStoreCopySettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("jewahovggtgxbwdd")
    public suspend fun targetDataStoreCopySettings(vararg values: TargetCopySettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetDataStoreCopySettings = mapped
    }

    internal fun build(): SourceLifeCycleArgs = SourceLifeCycleArgs(
        deleteAfter = deleteAfter ?: throw PulumiNullFieldException("deleteAfter"),
        sourceDataStore = sourceDataStore ?: throw PulumiNullFieldException("sourceDataStore"),
        targetDataStoreCopySettings = targetDataStoreCopySettings,
    )
}
