@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.StorageSettingArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.StorageSettingStoreTypes
import com.pulumi.azurenative.dataprotection.kotlin.enums.StorageSettingTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage setting
 * @property datastoreType Gets or sets the type of the datastore.
 * @property type Gets or sets the type.
 */
public data class StorageSettingArgs(
    public val datastoreType: Output<Either<String, StorageSettingStoreTypes>>? = null,
    public val type: Output<Either<String, StorageSettingTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.StorageSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.StorageSettingArgs =
        com.pulumi.azurenative.dataprotection.inputs.StorageSettingArgs.builder()
            .datastoreType(
                datastoreType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageSettingArgs].
 */
@PulumiTagMarker
public class StorageSettingArgsBuilder internal constructor() {
    private var datastoreType: Output<Either<String, StorageSettingStoreTypes>>? = null

    private var type: Output<Either<String, StorageSettingTypes>>? = null

    /**
     * @param value Gets or sets the type of the datastore.
     */
    @JvmName("dbnldcgwlhdgecor")
    public suspend fun datastoreType(`value`: Output<Either<String, StorageSettingStoreTypes>>) {
        this.datastoreType = value
    }

    /**
     * @param value Gets or sets the type.
     */
    @JvmName("bwcogrmflopefrix")
    public suspend fun type(`value`: Output<Either<String, StorageSettingTypes>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the type of the datastore.
     */
    @JvmName("cuyvpfgidfrxxlrx")
    public suspend fun datastoreType(`value`: Either<String, StorageSettingStoreTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value Gets or sets the type of the datastore.
     */
    @JvmName("dvuqqysvnionsbrk")
    public fun datastoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageSettingStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value Gets or sets the type of the datastore.
     */
    @JvmName("ohtblelfdochtagu")
    public fun datastoreType(`value`: StorageSettingStoreTypes) {
        val toBeMapped = Either.ofRight<String, StorageSettingStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value Gets or sets the type.
     */
    @JvmName("pkpblmivifdjwuqy")
    public suspend fun type(`value`: Either<String, StorageSettingTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the type.
     */
    @JvmName("pptrwgxigoknypsb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageSettingTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the type.
     */
    @JvmName("fcmtemgtmvgxiqfy")
    public fun type(`value`: StorageSettingTypes) {
        val toBeMapped = Either.ofRight<String, StorageSettingTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StorageSettingArgs = StorageSettingArgs(
        datastoreType = datastoreType,
        type = type,
    )
}
