@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure backup parameters
 * @property backupType BackupType ; Full/Incremental etc
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AzureBackupParams'.
 */
public data class AzureBackupParamsResponse(
    public val backupType: String,
    public val objectType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AzureBackupParamsResponse):
            AzureBackupParamsResponse = AzureBackupParamsResponse(
            backupType = javaType.backupType(),
            objectType = javaType.objectType(),
        )
    }
}
