@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Azure backup rule
 * @property backupParameters BackupParameters base
 * @property dataStore DataStoreInfo base
 * @property name
 * @property objectType
 * Expected value is 'AzureBackupRule'.
 * @property trigger Trigger context
 */
public data class AzureBackupRuleResponse(
    public val backupParameters: AzureBackupParamsResponse? = null,
    public val dataStore: DataStoreInfoBaseResponse,
    public val name: String,
    public val objectType: String,
    public val trigger: Either<AdhocBasedTriggerContextResponse, ScheduleBasedTriggerContextResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AzureBackupRuleResponse):
            AzureBackupRuleResponse = AzureBackupRuleResponse(
            backupParameters = javaType.backupParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.AzureBackupParamsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataStore = javaType.dataStore().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.DataStoreInfoBaseResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            objectType = javaType.objectType(),
            trigger = javaType.trigger().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.dataprotection.kotlin.outputs.AdhocBasedTriggerContextResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.dataprotection.kotlin.outputs.ScheduleBasedTriggerContextResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
