@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Backup Vault
 * @property featureSettings Feature Settings
 * @property isVaultProtectedByResourceGuard Is vault protected by resource guard
 * @property monitoringSettings Monitoring Settings
 * @property provisioningState Provisioning state of the BackupVault resource
 * @property resourceMoveDetails Resource move details for backup vault
 * @property resourceMoveState Resource move state for backup vault
 * @property securitySettings Security Settings
 * @property storageSettings Storage Settings
 */
public data class BackupVaultResponse(
    public val featureSettings: FeatureSettingsResponse? = null,
    public val isVaultProtectedByResourceGuard: Boolean,
    public val monitoringSettings: MonitoringSettingsResponse? = null,
    public val provisioningState: String,
    public val resourceMoveDetails: ResourceMoveDetailsResponse,
    public val resourceMoveState: String,
    public val securitySettings: SecuritySettingsResponse? = null,
    public val storageSettings: List<StorageSettingResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.BackupVaultResponse):
            BackupVaultResponse = BackupVaultResponse(
            featureSettings = javaType.featureSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.FeatureSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isVaultProtectedByResourceGuard = javaType.isVaultProtectedByResourceGuard(),
            monitoringSettings = javaType.monitoringSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.MonitoringSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceMoveDetails = javaType.resourceMoveDetails().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceMoveDetailsResponse.Companion.toKotlin(args0)
            }),
            resourceMoveState = javaType.resourceMoveState(),
            securitySettings = javaType.securitySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.SecuritySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageSettings = javaType.storageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.StorageSettingResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
