@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Retention tag
 * @property eTag Retention Tag version.
 * @property id Retention Tag version.
 * @property tagName Retention Tag Name to relate it to retention rule.
 */
public data class RetentionTagResponse(
    public val eTag: String,
    public val id: String,
    public val tagName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.RetentionTagResponse):
            RetentionTagResponse = RetentionTagResponse(
            eTag = javaType.eTag(),
            id = javaType.id(),
            tagName = javaType.tagName(),
        )
    }
}
