@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Error object used by layers that have access to localized content, and propagate that to user
 * @property code Unique code for this error
 * @property details Additional related Errors
 * @property innerError Inner Error
 * @property isRetryable Whether the operation will be retryable or not
 * @property isUserError Whether the operation is due to a user error or service error
 * @property message
 * @property properties Any key value pairs that can be injected inside error object
 * @property recommendedAction RecommendedAction � localized.
 * @property target Target of the error.
 */
public data class UserFacingErrorResponse(
    public val code: String? = null,
    public val details: List<UserFacingErrorResponse>? = null,
    public val innerError: InnerErrorResponse? = null,
    public val isRetryable: Boolean? = null,
    public val isUserError: Boolean? = null,
    public val message: String? = null,
    public val properties: Map<String, String>? = null,
    public val recommendedAction: List<String>? = null,
    public val target: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.UserFacingErrorResponse):
            UserFacingErrorResponse = UserFacingErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.UserFacingErrorResponse.Companion.toKotlin(args0)
                })
            }),
            innerError = javaType.innerError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.InnerErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isRetryable = javaType.isRetryable().map({ args0 -> args0 }).orElse(null),
            isUserError = javaType.isUserError().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            recommendedAction = javaType.recommendedAction().map({ args0 -> args0 }),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
