@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelPropertiesResponse.Companion.toKotlin as protectedItemModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemModelResponseSystemData.Companion.toKotlin as protectedItemModelResponseSystemDataToKotlin

/**
 * Builder for [ProtectedItem].
 */
@PulumiTagMarker
public class ProtectedItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectedItemArgs = ProtectedItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectedItemArgsBuilder.() -> Unit) {
        val builder = ProtectedItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProtectedItem {
        val builtJavaResource =
            com.pulumi.azurenative.datareplication.ProtectedItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectedItem(builtJavaResource)
    }
}

/**
 * Protected item model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### ProtectedItem_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.DataReplication.ProtectedItem("protectedItem", new()
 *     {
 *         Properties = new AzureNative.DataReplication.Inputs.ProtectedItemModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "ProtectedItemModelCustomProperties" },
 *             },
 *             PolicyName = "tjoeiynplt",
 *             ReplicationExtensionName = "jwxdo",
 *         },
 *         ProtectedItemName = "d",
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewProtectedItem(ctx, "protectedItem", &datareplication.ProtectedItemArgs{
 * Properties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("ProtectedItemModelCustomProperties"),
 * },
 * PolicyName: pulumi.String("tjoeiynplt"),
 * ReplicationExtensionName: pulumi.String("jwxdo"),
 * },
 * ProtectedItemName: pulumi.String("d"),
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.ProtectedItem;
 * import com.pulumi.azurenative.datareplication.ProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("customProperties", Map.of("instanceType", "ProtectedItemModelCustomProperties")),
 *                 Map.entry("policyName", "tjoeiynplt"),
 *                 Map.entry("replicationExtensionName", "jwxdo")
 *             ))
 *             .protectedItemName("d")
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:ProtectedItem t /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/protectedItems/{protectedItemName}
 * ```
 */
public class ProtectedItem internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.ProtectedItem,
) : KotlinCustomResource(javaResource, ProtectedItemMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Protected item model properties.
     */
    public val properties: Output<ProtectedItemModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                protectedItemModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<ProtectedItemModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                protectedItemModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProtectedItemMapper : ResourceMapper<ProtectedItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.ProtectedItem::class == javaResource::class

    override fun map(javaResource: Resource): ProtectedItem = ProtectedItem(
        javaResource as
            com.pulumi.azurenative.datareplication.ProtectedItem,
    )
}

/**
 * @see [ProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectedItem].
 */
public suspend fun protectedItem(
    name: String,
    block: suspend ProtectedItemResourceBuilder.() -> Unit,
): ProtectedItem {
    val builder = ProtectedItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectedItem(name: String): ProtectedItem {
    val builder = ProtectedItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
