@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.VaultArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.VaultModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.VaultModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Vault model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Vault_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.DataReplication.Vault("vault", new()
 *     {
 *         Location = "eck",
 *         Properties = new AzureNative.DataReplication.Inputs.VaultModelPropertiesArgs
 *         {
 *             VaultType = "DisasterRecovery",
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         Tags =
 *         {
 *             { "key5359", "ljfilxolxzuxrauopwtyxghrp" },
 *         },
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datareplication.NewVault(ctx, "vault", &datareplication.VaultArgs{
 * 			Location: pulumi.String("eck"),
 * 			Properties: &datareplication.VaultModelPropertiesArgs{
 * 				VaultType: pulumi.String("DisasterRecovery"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * 			Tags: pulumi.StringMap{
 * 				"key5359": pulumi.String("ljfilxolxzuxrauopwtyxghrp"),
 * 			},
 * 			VaultName: pulumi.String("4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Vault;
 * import com.pulumi.azurenative.datareplication.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("eck")
 *             .properties(Map.of("vaultType", "DisasterRecovery"))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .tags(Map.of("key5359", "ljfilxolxzuxrauopwtyxghrp"))
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Vault bqgyqxmnlgwqxbmajddqwtao /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}
 * ```
 * @property location Gets or sets the location of the vault.
 * @property properties Vault properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Gets or sets the resource tags.
 * @property vaultName The vault name.
 */
public data class VaultArgs(
    public val location: Output<String>? = null,
    public val properties: Output<VaultModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.VaultArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.VaultArgs =
        com.pulumi.azurenative.datareplication.VaultArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<VaultModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Gets or sets the location of the vault.
     */
    @JvmName("hbmsjcyrmcxtkugc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Vault properties.
     */
    @JvmName("sihxbjtpygmxfvxf")
    public suspend fun properties(`value`: Output<VaultModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ehwwhxccawptdkcp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("bupxrbhhehghqiyj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vault name.
     */
    @JvmName("tmmncojpfcphnspx")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Gets or sets the location of the vault.
     */
    @JvmName("famyrrdoxcnsonna")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Vault properties.
     */
    @JvmName("glfnefklufqxxgcx")
    public suspend fun properties(`value`: VaultModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Vault properties.
     */
    @JvmName("dkcmrbvkuqjwicpl")
    public suspend fun properties(argument: suspend VaultModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VaultModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gpmtafmuipmobvxi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the resource tags.
     */
    @JvmName("fsaeorgwwiqgsoyn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the resource tags.
     */
    @JvmName("nnjfkqeepdwsytno")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("ytnsuuuqcvmuaacd")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
