@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.GetDraPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricAgentName The fabric agent (Dra) name.
 * @property fabricName The fabric name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDraPlainArgs(
    public val fabricAgentName: String,
    public val fabricName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.GetDraPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.GetDraPlainArgs =
        com.pulumi.azurenative.datareplication.inputs.GetDraPlainArgs.builder()
            .fabricAgentName(fabricAgentName.let({ args0 -> args0 }))
            .fabricName(fabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDraPlainArgs].
 */
@PulumiTagMarker
public class GetDraPlainArgsBuilder internal constructor() {
    private var fabricAgentName: String? = null

    private var fabricName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The fabric agent (Dra) name.
     */
    @JvmName("mbqatvhlacglrkok")
    public suspend fun fabricAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricAgentName = mapped
    }

    /**
     * @param value The fabric name.
     */
    @JvmName("qdpeejhyghgrcafn")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kdfiyspsikpogfou")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDraPlainArgs = GetDraPlainArgs(
        fabricAgentName = fabricAgentName ?: throw PulumiNullFieldException("fabricAgentName"),
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
