@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.ProtectedItemModelPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Protected item model properties.
 * @property customProperties Protected item model custom properties.
 * @property policyName Gets or sets the policy name.
 * @property replicationExtensionName Gets or sets the replication extension name.
 */
public data class ProtectedItemModelPropertiesArgs(
    public val customProperties:
    Output<Either<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs, VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs>>,
    public val policyName: Output<String>,
    public val replicationExtensionName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.ProtectedItemModelPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.ProtectedItemModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.ProtectedItemModelPropertiesArgs.builder()
            .customProperties(
                customProperties.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .policyName(policyName.applyValue({ args0 -> args0 }))
            .replicationExtensionName(replicationExtensionName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectedItemModelPropertiesArgs].
 */
@PulumiTagMarker
public class ProtectedItemModelPropertiesArgsBuilder internal constructor() {
    private var customProperties:
        Output<Either<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs, VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs>>? =
        null

    private var policyName: Output<String>? = null

    private var replicationExtensionName: Output<String>? = null

    /**
     * @param value Protected item model custom properties.
     */
    @JvmName("naujwbxlfwnkjtns")
    public suspend
    fun customProperties(`value`: Output<Either<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs, VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    /**
     * @param value Gets or sets the policy name.
     */
    @JvmName("imcbykjcwkkpwivk")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Gets or sets the replication extension name.
     */
    @JvmName("dntoahhmjtohdntk")
    public suspend fun replicationExtensionName(`value`: Output<String>) {
        this.replicationExtensionName = value
    }

    /**
     * @param value Protected item model custom properties.
     */
    @JvmName("frqdngbmroillreh")
    public suspend
    fun customProperties(`value`: Either<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs, VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Protected item model custom properties.
     */
    @JvmName("sdbvxmohwcmpxmju")
    public fun customProperties(`value`: HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofLeft<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs,
            VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Protected item model custom properties.
     */
    @JvmName("lojbtvxayslqkirl")
    public fun customProperties(`value`: VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofRight<HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs,
            VMwareToAzStackHCIProtectedItemModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Gets or sets the policy name.
     */
    @JvmName("ociskgdufffimtkb")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Gets or sets the replication extension name.
     */
    @JvmName("klgblorsnlwyvecd")
    public suspend fun replicationExtensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationExtensionName = mapped
    }

    internal fun build(): ProtectedItemModelPropertiesArgs = ProtectedItemModelPropertiesArgs(
        customProperties = customProperties ?: throw PulumiNullFieldException("customProperties"),
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        replicationExtensionName = replicationExtensionName ?: throw
            PulumiNullFieldException("replicationExtensionName"),
    )
}
