@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.StorageContainerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage container properties.
 * @property clusterSharedVolumePath Gets or sets the ClusterSharedVolumePath.
 * @property name Gets or sets the Name.
 */
public data class StorageContainerPropertiesArgs(
    public val clusterSharedVolumePath: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.StorageContainerPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.StorageContainerPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.StorageContainerPropertiesArgs.builder()
            .clusterSharedVolumePath(clusterSharedVolumePath.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageContainerPropertiesArgs].
 */
@PulumiTagMarker
public class StorageContainerPropertiesArgsBuilder internal constructor() {
    private var clusterSharedVolumePath: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the ClusterSharedVolumePath.
     */
    @JvmName("plodwqydliupflwb")
    public suspend fun clusterSharedVolumePath(`value`: Output<String>) {
        this.clusterSharedVolumePath = value
    }

    /**
     * @param value Gets or sets the Name.
     */
    @JvmName("xhgkdudxspvbgrsk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the ClusterSharedVolumePath.
     */
    @JvmName("hxfyiyttikpkvixk")
    public suspend fun clusterSharedVolumePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterSharedVolumePath = mapped
    }

    /**
     * @param value Gets or sets the Name.
     */
    @JvmName("euwhdbxyuibyvmti")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StorageContainerPropertiesArgs = StorageContainerPropertiesArgs(
        clusterSharedVolumePath = clusterSharedVolumePath ?: throw
            PulumiNullFieldException("clusterSharedVolumePath"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
