@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.VMwareDraModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * VMware DRA model custom properties.
 * @property biosId Gets or sets the BIOS Id of the DRA machine.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMware'.
 * @property marsAuthenticationIdentity Identity model.
 */
public data class VMwareDraModelCustomPropertiesArgs(
    public val biosId: Output<String>,
    public val instanceType: Output<String>,
    public val marsAuthenticationIdentity: Output<IdentityModelArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.VMwareDraModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.VMwareDraModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.VMwareDraModelCustomPropertiesArgs.builder()
            .biosId(biosId.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .marsAuthenticationIdentity(
                marsAuthenticationIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VMwareDraModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class VMwareDraModelCustomPropertiesArgsBuilder internal constructor() {
    private var biosId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var marsAuthenticationIdentity: Output<IdentityModelArgs>? = null

    /**
     * @param value Gets or sets the BIOS Id of the DRA machine.
     */
    @JvmName("xkdvwoqoomxipcrg")
    public suspend fun biosId(`value`: Output<String>) {
        this.biosId = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMware'.
     */
    @JvmName("lugofqlrisrhgryx")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Identity model.
     */
    @JvmName("bswykhrcfrvignsj")
    public suspend fun marsAuthenticationIdentity(`value`: Output<IdentityModelArgs>) {
        this.marsAuthenticationIdentity = value
    }

    /**
     * @param value Gets or sets the BIOS Id of the DRA machine.
     */
    @JvmName("cseorkgsftppecjc")
    public suspend fun biosId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.biosId = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMware'.
     */
    @JvmName("ouhdddlbjrfoqarl")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Identity model.
     */
    @JvmName("rpqypiucqknsnbju")
    public suspend fun marsAuthenticationIdentity(`value`: IdentityModelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marsAuthenticationIdentity = mapped
    }

    /**
     * @param argument Identity model.
     */
    @JvmName("vojfrsuddfsbgqmu")
    public suspend
    fun marsAuthenticationIdentity(argument: suspend IdentityModelArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.marsAuthenticationIdentity = mapped
    }

    internal fun build(): VMwareDraModelCustomPropertiesArgs = VMwareDraModelCustomPropertiesArgs(
        biosId = biosId ?: throw PulumiNullFieldException("biosId"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        marsAuthenticationIdentity = marsAuthenticationIdentity ?: throw
            PulumiNullFieldException("marsAuthenticationIdentity"),
    )
}
