@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * HyperV migrate fabric model custom properties.
 * @property fabricContainerId Gets or sets the fabric container Id.
 * @property fabricResourceId Gets or sets the fabric resource Id.
 * @property hyperVSiteId Gets or sets the ARM Id of the HyperV site.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'HyperVMigrate'.
 * @property migrationHubUri Gets or sets the migration hub Uri.
 * @property migrationSolutionId Gets or sets the migration solution ARM Id.
 */
public data class HyperVMigrateFabricModelCustomPropertiesResponse(
    public val fabricContainerId: String,
    public val fabricResourceId: String,
    public val hyperVSiteId: String,
    public val instanceType: String,
    public val migrationHubUri: String,
    public val migrationSolutionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.HyperVMigrateFabricModelCustomPropertiesResponse):
            HyperVMigrateFabricModelCustomPropertiesResponse =
            HyperVMigrateFabricModelCustomPropertiesResponse(
                fabricContainerId = javaType.fabricContainerId(),
                fabricResourceId = javaType.fabricResourceId(),
                hyperVSiteId = javaType.hyperVSiteId(),
                instanceType = javaType.instanceType(),
                migrationHubUri = javaType.migrationHubUri(),
                migrationSolutionId = javaType.migrationSolutionId(),
            )
    }
}
