@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * HyperVToAzStack disk input.
 * @property diskFileFormat Gets or sets the type of the virtual hard disk, vhd or vhdx.
 * @property diskId Gets or sets the disk Id.
 * @property diskSizeGB Gets or sets the disk size in GB.
 * @property isDynamic Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
 * disk.
 * @property isOsDisk Gets or sets a value indicating whether disk is os disk.
 * @property storageContainerId Gets or sets the target storage account ARM Id.
 */
public data class HyperVToAzStackHCIDiskInputResponse(
    public val diskFileFormat: String,
    public val diskId: String,
    public val diskSizeGB: Double,
    public val isDynamic: Boolean? = null,
    public val isOsDisk: Boolean,
    public val storageContainerId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.HyperVToAzStackHCIDiskInputResponse):
            HyperVToAzStackHCIDiskInputResponse = HyperVToAzStackHCIDiskInputResponse(
            diskFileFormat = javaType.diskFileFormat(),
            diskId = javaType.diskId(),
            diskSizeGB = javaType.diskSizeGB(),
            isDynamic = javaType.isDynamic().map({ args0 -> args0 }).orElse(null),
            isOsDisk = javaType.isOsDisk(),
            storageContainerId = javaType.storageContainerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
