@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Protected item dynamic memory config.
 * @property maximumMemoryInMegaBytes Gets or sets maximum memory in MB.
 * @property minimumMemoryInMegaBytes Gets or sets minimum memory in MB.
 * @property targetMemoryBufferPercentage Gets or sets target memory buffer in %.
 */
public data class ProtectedItemDynamicMemoryConfigResponse(
    public val maximumMemoryInMegaBytes: Double,
    public val minimumMemoryInMegaBytes: Double,
    public val targetMemoryBufferPercentage: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.ProtectedItemDynamicMemoryConfigResponse):
            ProtectedItemDynamicMemoryConfigResponse = ProtectedItemDynamicMemoryConfigResponse(
            maximumMemoryInMegaBytes = javaType.maximumMemoryInMegaBytes(),
            minimumMemoryInMegaBytes = javaType.minimumMemoryInMegaBytes(),
            targetMemoryBufferPercentage = javaType.targetMemoryBufferPercentage(),
        )
    }
}
