@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VMware to AzStackHCI Protected item model custom properties.
 * @property activeLocation Gets or sets the location of the protected item.
 * @property customLocationRegion Gets or sets the location of Azure Arc HCI custom location resource.
 * @property disksToInclude Gets or sets the list of disks to replicate.
 * @property dynamicMemoryConfig Protected item dynamic memory config.
 * @property fabricDiscoveryMachineId Gets or sets the ARM Id of the discovered machine.
 * @property failoverRecoveryPointId Gets or sets the recovery point Id to which the VM was failed over.
 * @property firmwareType Gets or sets the firmware type.
 * @property hyperVGeneration Gets or sets the hypervisor generation of the virtual machine possible values are 1,2.
 * @property initialReplicationProgressPercentage Gets or sets the initial replication progress percentage. This is calculated based on
 * total bytes processed for all disks in the source VM.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareToAzStackHCI'.
 * @property isDynamicRam Gets or sets a value indicating whether memory is dynamical.
 * @property lastRecoveryPointId Gets or sets the last recovery point Id.
 * @property lastRecoveryPointReceived Gets or sets the last recovery point received time.
 * @property lastReplicationUpdateTime Gets or sets the latest timestamp that replication status is updated.
 * @property migrationProgressPercentage Gets or sets the migration progress percentage.
 * @property nicsToInclude Gets or sets the list of VM NIC to replicate.
 * @property osName Gets or sets the name of the OS.
 * @property osType Gets or sets the type of the OS.
 * @property performAutoResync Gets or sets a value indicating whether auto resync is to be done.
 * @property protectedDisks Gets or sets the list of protected disks.
 * @property protectedNics Gets or sets the VM NIC details.
 * @property resumeProgressPercentage Gets or sets the resume progress percentage.
 * @property resumeRetryCount Gets or sets the resume retry count.
 * @property resyncProgressPercentage Gets or sets the resync progress percentage. This is calculated based on total bytes
 * processed for all disks in the source VM.
 * @property resyncRequired Gets or sets a value indicating whether resync is required.
 * @property resyncRetryCount Gets or sets the resync retry count.
 * @property resyncState Gets or sets the resync state.
 * @property runAsAccountId Gets or sets the run as account Id.
 * @property sourceApplianceName Gets or sets the source appliance name.
 * @property sourceCpuCores Gets or sets the source VM CPU cores.
 * @property sourceDraName Gets or sets the source DRA name.
 * @property sourceMemoryInMegaBytes Gets or sets the source VM ram memory size in megabytes.
 * @property sourceVmName Gets or sets the source VM display name.
 * @property storageContainerId Gets or sets the target storage container ARM Id.
 * @property targetApplianceName Gets or sets the target appliance name.
 * @property targetArcClusterCustomLocationId Gets or sets the Target Arc Cluster Custom Location ARM Id.
 * @property targetAzStackHciClusterName Gets or sets the Target AzStackHCI cluster name.
 * @property targetCpuCores Gets or sets the target CPU cores.
 * @property targetDraName Gets or sets the target DRA name.
 * @property targetHciClusterId Gets or sets the Target HCI Cluster ARM Id.
 * @property targetLocation Gets or sets the target location.
 * @property targetMemoryInMegaBytes Gets or sets the target memory in mega-bytes.
 * @property targetNetworkId Gets or sets the target network Id within AzStackHCI Cluster.
 * @property targetResourceGroupId Gets or sets the target resource group ARM Id.
 * @property targetVmBiosId Gets or sets the BIOS Id of the target AzStackHCI VM.
 * @property targetVmName Gets or sets the target VM display name.
 * @property testNetworkId Gets or sets the target test network Id within AzStackHCI Cluster.
 */
public data class VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse(
    public val activeLocation: String,
    public val customLocationRegion: String,
    public val disksToInclude: List<VMwareToAzStackHCIDiskInputResponse>,
    public val dynamicMemoryConfig: ProtectedItemDynamicMemoryConfigResponse? = null,
    public val fabricDiscoveryMachineId: String,
    public val failoverRecoveryPointId: String,
    public val firmwareType: String,
    public val hyperVGeneration: String,
    public val initialReplicationProgressPercentage: Int,
    public val instanceType: String,
    public val isDynamicRam: Boolean? = null,
    public val lastRecoveryPointId: String,
    public val lastRecoveryPointReceived: String,
    public val lastReplicationUpdateTime: String,
    public val migrationProgressPercentage: Int,
    public val nicsToInclude: List<VMwareToAzStackHCINicInputResponse>,
    public val osName: String,
    public val osType: String,
    public val performAutoResync: Boolean? = null,
    public val protectedDisks: List<VMwareToAzStackHCIProtectedDiskPropertiesResponse>,
    public val protectedNics: List<VMwareToAzStackHCIProtectedNicPropertiesResponse>,
    public val resumeProgressPercentage: Int,
    public val resumeRetryCount: Double,
    public val resyncProgressPercentage: Int,
    public val resyncRequired: Boolean,
    public val resyncRetryCount: Double,
    public val resyncState: String,
    public val runAsAccountId: String,
    public val sourceApplianceName: String,
    public val sourceCpuCores: Int,
    public val sourceDraName: String,
    public val sourceMemoryInMegaBytes: Double,
    public val sourceVmName: String,
    public val storageContainerId: String,
    public val targetApplianceName: String,
    public val targetArcClusterCustomLocationId: String,
    public val targetAzStackHciClusterName: String,
    public val targetCpuCores: Int? = null,
    public val targetDraName: String,
    public val targetHciClusterId: String,
    public val targetLocation: String,
    public val targetMemoryInMegaBytes: Int? = null,
    public val targetNetworkId: String? = null,
    public val targetResourceGroupId: String,
    public val targetVmBiosId: String,
    public val targetVmName: String? = null,
    public val testNetworkId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse):
            VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse =
            VMwareToAzStackHCIProtectedItemModelCustomPropertiesResponse(
                activeLocation = javaType.activeLocation(),
                customLocationRegion = javaType.customLocationRegion(),
                disksToInclude = javaType.disksToInclude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIDiskInputResponse.Companion.toKotlin(args0)
                    })
                }),
                dynamicMemoryConfig = javaType.dynamicMemoryConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.ProtectedItemDynamicMemoryConfigResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fabricDiscoveryMachineId = javaType.fabricDiscoveryMachineId(),
                failoverRecoveryPointId = javaType.failoverRecoveryPointId(),
                firmwareType = javaType.firmwareType(),
                hyperVGeneration = javaType.hyperVGeneration(),
                initialReplicationProgressPercentage = javaType.initialReplicationProgressPercentage(),
                instanceType = javaType.instanceType(),
                isDynamicRam = javaType.isDynamicRam().map({ args0 -> args0 }).orElse(null),
                lastRecoveryPointId = javaType.lastRecoveryPointId(),
                lastRecoveryPointReceived = javaType.lastRecoveryPointReceived(),
                lastReplicationUpdateTime = javaType.lastReplicationUpdateTime(),
                migrationProgressPercentage = javaType.migrationProgressPercentage(),
                nicsToInclude = javaType.nicsToInclude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCINicInputResponse.Companion.toKotlin(args0)
                    })
                }),
                osName = javaType.osName(),
                osType = javaType.osType(),
                performAutoResync = javaType.performAutoResync().map({ args0 -> args0 }).orElse(null),
                protectedDisks = javaType.protectedDisks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIProtectedDiskPropertiesResponse.Companion.toKotlin(args0)
                    })
                }),
                protectedNics = javaType.protectedNics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datareplication.kotlin.outputs.VMwareToAzStackHCIProtectedNicPropertiesResponse.Companion.toKotlin(args0)
                    })
                }),
                resumeProgressPercentage = javaType.resumeProgressPercentage(),
                resumeRetryCount = javaType.resumeRetryCount(),
                resyncProgressPercentage = javaType.resyncProgressPercentage(),
                resyncRequired = javaType.resyncRequired(),
                resyncRetryCount = javaType.resyncRetryCount(),
                resyncState = javaType.resyncState(),
                runAsAccountId = javaType.runAsAccountId(),
                sourceApplianceName = javaType.sourceApplianceName(),
                sourceCpuCores = javaType.sourceCpuCores(),
                sourceDraName = javaType.sourceDraName(),
                sourceMemoryInMegaBytes = javaType.sourceMemoryInMegaBytes(),
                sourceVmName = javaType.sourceVmName(),
                storageContainerId = javaType.storageContainerId(),
                targetApplianceName = javaType.targetApplianceName(),
                targetArcClusterCustomLocationId = javaType.targetArcClusterCustomLocationId(),
                targetAzStackHciClusterName = javaType.targetAzStackHciClusterName(),
                targetCpuCores = javaType.targetCpuCores().map({ args0 -> args0 }).orElse(null),
                targetDraName = javaType.targetDraName(),
                targetHciClusterId = javaType.targetHciClusterId(),
                targetLocation = javaType.targetLocation(),
                targetMemoryInMegaBytes = javaType.targetMemoryInMegaBytes().map({ args0 -> args0 }).orElse(null),
                targetNetworkId = javaType.targetNetworkId().map({ args0 -> args0 }).orElse(null),
                targetResourceGroupId = javaType.targetResourceGroupId(),
                targetVmBiosId = javaType.targetVmBiosId(),
                targetVmName = javaType.targetVmName().map({ args0 -> args0 }).orElse(null),
                testNetworkId = javaType.testNetworkId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
