@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.OutputType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Blob data set mapping.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         ContainerName = "C1",
 *         DataSetId = "a08f184b-0567-4b11-ba22-a1199336d226",
 *         DataSetMappingName = "DatasetMapping1",
 *         FilePath = "file21",
 *         Kind = "Blob",
 *         ResourceGroup = "SampleResourceGroup",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         StorageAccountName = "storage2",
 *         SubscriptionId = "433a8dfd-e5d5-4e77-ad86-90acdc75eb1a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			ContainerName:         pulumi.String("C1"),
 * 			DataSetId:             pulumi.String("a08f184b-0567-4b11-ba22-a1199336d226"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			FilePath:              pulumi.String("file21"),
 * 			Kind:                  pulumi.String("Blob"),
 * 			ResourceGroup:         pulumi.String("SampleResourceGroup"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			StorageAccountName:    pulumi.String("storage2"),
 * 			SubscriptionId:        pulumi.String("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .containerName("C1")
 *             .dataSetId("a08f184b-0567-4b11-ba22-a1199336d226")
 *             .dataSetMappingName("DatasetMapping1")
 *             .filePath("file21")
 *             .kind("Blob")
 *             .resourceGroup("SampleResourceGroup")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .storageAccountName("storage2")
 *             .subscriptionId("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:BlobDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 * @property accountName The name of the share account.
 * @property containerName Container that has the file path.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingName The name of the data set mapping to be created.
 * @property filePath File path within the source data set
 * @property kind Kind of data set mapping.
 * Expected value is 'Blob'.
 * @property outputType File output type
 * @property resourceGroup Resource group of storage account.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 * @property storageAccountName Storage account name of the source data set.
 * @property subscriptionId Subscription id of storage account.
 */
public data class BlobDataSetMappingArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetMappingName: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val outputType: Output<Either<String, OutputType>>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.BlobDataSetMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.BlobDataSetMappingArgs =
        com.pulumi.azurenative.datashare.BlobDataSetMappingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .outputType(
                outputType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobDataSetMappingArgs].
 */
@PulumiTagMarker
public class BlobDataSetMappingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetMappingName: Output<String>? = null

    private var filePath: Output<String>? = null

    private var kind: Output<String>? = null

    private var outputType: Output<Either<String, OutputType>>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("vxqqvrdohsikixoi")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Container that has the file path.
     */
    @JvmName("midsopjmyajproov")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("vfsajrfbxifrstml")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("jbwtvtjltpeqgkja")
    public suspend fun dataSetMappingName(`value`: Output<String>) {
        this.dataSetMappingName = value
    }

    /**
     * @param value File path within the source data set
     */
    @JvmName("sifhwkyhtwpvubkv")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'Blob'.
     */
    @JvmName("nsonispadnhpxakr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value File output type
     */
    @JvmName("qbyscdgilckwgari")
    public suspend fun outputType(`value`: Output<Either<String, OutputType>>) {
        this.outputType = value
    }

    /**
     * @param value Resource group of storage account.
     */
    @JvmName("mbwuxhkhkhuslpxn")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("llmuksgvxyhumofj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("egxttfqyfnifdqdh")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Storage account name of the source data set.
     */
    @JvmName("mhuwbigsrioyjsut")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Subscription id of storage account.
     */
    @JvmName("ftkimckmyligdngi")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("usbbychudrqeetvn")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Container that has the file path.
     */
    @JvmName("grixvquqjyqdvakf")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("eisvsftyiermfptm")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("lgdamtaritaqhohx")
    public suspend fun dataSetMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value File path within the source data set
     */
    @JvmName("gwjjagjnnptnfhsr")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'Blob'.
     */
    @JvmName("rmwlixlaimacbulb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value File output type
     */
    @JvmName("qsvwtgcpjcgajoyu")
    public suspend fun outputType(`value`: Either<String, OutputType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value File output type
     */
    @JvmName("gaslfovxeanefyxr")
    public fun outputType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value File output type
     */
    @JvmName("ipcyfdpulvqnxeqi")
    public fun outputType(`value`: OutputType) {
        val toBeMapped = Either.ofRight<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value Resource group of storage account.
     */
    @JvmName("rttfnxvikcrqsuhw")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("atkduoxpdeafhhwt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("ccvjnunahcqucowk")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Storage account name of the source data set.
     */
    @JvmName("qxklpayrvioacchg")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Subscription id of storage account.
     */
    @JvmName("hjrpxfllatprldpa")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): BlobDataSetMappingArgs = BlobDataSetMappingArgs(
        accountName = accountName,
        containerName = containerName,
        dataSetId = dataSetId,
        dataSetMappingName = dataSetMappingName,
        filePath = filePath,
        kind = kind,
        outputType = outputType,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        shareSubscriptionName = shareSubscriptionName,
        storageAccountName = storageAccountName,
        subscriptionId = subscriptionId,
    )
}
