@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.KustoTableDataSetArgs.builder
import com.pulumi.azurenative.datashare.kotlin.inputs.TableLevelSharingPropertiesArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.TableLevelSharingPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A kusto table data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         Kind = "KustoTable",
 *         KustoDatabaseResourceId = "/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1/databases/Database1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         TableLevelSharingProperties = new AzureNative.DataShare.Inputs.TableLevelSharingPropertiesArgs
 *         {
 *             ExternalTablesToExclude = new[]
 *             {
 *                 "test11",
 *                 "test12",
 *             },
 *             ExternalTablesToInclude = new[]
 *             {
 *                 "test9",
 *                 "test10",
 *             },
 *             MaterializedViewsToExclude = new[]
 *             {
 *                 "test7",
 *                 "test8",
 *             },
 *             MaterializedViewsToInclude = new[]
 *             {
 *                 "test5",
 *                 "test6",
 *             },
 *             TablesToExclude = new[]
 *             {
 *                 "test3",
 *                 "test4",
 *             },
 *             TablesToInclude = new[]
 *             {
 *                 "test1",
 *                 "test2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:             pulumi.String("Account1"),
 * 			DataSetName:             pulumi.String("Dataset1"),
 * 			Kind:                    pulumi.String("KustoTable"),
 * 			KustoDatabaseResourceId: pulumi.String("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1/databases/Database1"),
 * 			ResourceGroupName:       pulumi.String("SampleResourceGroup"),
 * 			ShareName:               pulumi.String("Share1"),
 * 			TableLevelSharingProperties: &datashare.TableLevelSharingPropertiesArgs{
 * 				ExternalTablesToExclude: pulumi.StringArray{
 * 					pulumi.String("test11"),
 * 					pulumi.String("test12"),
 * 				},
 * 				ExternalTablesToInclude: pulumi.StringArray{
 * 					pulumi.String("test9"),
 * 					pulumi.String("test10"),
 * 				},
 * 				MaterializedViewsToExclude: pulumi.StringArray{
 * 					pulumi.String("test7"),
 * 					pulumi.String("test8"),
 * 				},
 * 				MaterializedViewsToInclude: pulumi.StringArray{
 * 					pulumi.String("test5"),
 * 					pulumi.String("test6"),
 * 				},
 * 				TablesToExclude: pulumi.StringArray{
 * 					pulumi.String("test3"),
 * 					pulumi.String("test4"),
 * 				},
 * 				TablesToInclude: pulumi.StringArray{
 * 					pulumi.String("test1"),
 * 					pulumi.String("test2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .kind("KustoTable")
 *             .kustoDatabaseResourceId("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1/databases/Database1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .tableLevelSharingProperties(Map.ofEntries(
 *                 Map.entry("externalTablesToExclude",
 *                     "test11",
 *                     "test12"),
 *                 Map.entry("externalTablesToInclude",
 *                     "test9",
 *                     "test10"),
 *                 Map.entry("materializedViewsToExclude",
 *                     "test7",
 *                     "test8"),
 *                 Map.entry("materializedViewsToInclude",
 *                     "test5",
 *                     "test6"),
 *                 Map.entry("tablesToExclude",
 *                     "test3",
 *                     "test4"),
 *                 Map.entry("tablesToInclude",
 *                     "test1",
 *                     "test2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSet = new AzureNative.DataShare.KustoTableDataSet("kustoTableDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSet(ctx, "kustoTableDataSet", &datashare.KustoTableDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSet;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSet = new KustoTableDataSet("kustoTableDataSet", KustoTableDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:KustoTableDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property kind Kind of data set.
 * Expected value is 'KustoTable'.
 * @property kustoDatabaseResourceId Resource id of the kusto database.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the data set to.
 * @property tableLevelSharingProperties Table level sharing properties for kusto database
 */
public data class KustoTableDataSetArgs(
    public val accountName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val kustoDatabaseResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.KustoTableDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.KustoTableDataSetArgs =
        com.pulumi.azurenative.datashare.KustoTableDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoDatabaseResourceId(kustoDatabaseResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .tableLevelSharingProperties(
                tableLevelSharingProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KustoTableDataSetArgs].
 */
@PulumiTagMarker
public class KustoTableDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var kind: Output<String>? = null

    private var kustoDatabaseResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("cvcdtfagfjvkunko")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("ltykarlttxxmrvgg")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'KustoTable'.
     */
    @JvmName("uhtkvnjwtpwtwdwa")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource id of the kusto database.
     */
    @JvmName("wtonwutrxosayvyy")
    public suspend fun kustoDatabaseResourceId(`value`: Output<String>) {
        this.kustoDatabaseResourceId = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hldbxdvtlksupupk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("mdbfbfuxqermywwm")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Table level sharing properties for kusto database
     */
    @JvmName("bafpgqiqnvybivnh")
    public suspend fun tableLevelSharingProperties(`value`: Output<TableLevelSharingPropertiesArgs>) {
        this.tableLevelSharingProperties = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("tlixcdvxopavtdvm")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("mpilxrtggpipgpvk")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'KustoTable'.
     */
    @JvmName("cukbjoeocqwwvkle")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource id of the kusto database.
     */
    @JvmName("kmbcyiythuuynhvv")
    public suspend fun kustoDatabaseResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoDatabaseResourceId = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xdggtqmvecaisdsj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("jhrsrjrhyregssah")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Table level sharing properties for kusto database
     */
    @JvmName("giighjdtctaffosb")
    public suspend fun tableLevelSharingProperties(`value`: TableLevelSharingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableLevelSharingProperties = mapped
    }

    /**
     * @param argument Table level sharing properties for kusto database
     */
    @JvmName("ndxkkmshpxbttqaa")
    public suspend
    fun tableLevelSharingProperties(argument: suspend TableLevelSharingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableLevelSharingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableLevelSharingProperties = mapped
    }

    internal fun build(): KustoTableDataSetArgs = KustoTableDataSetArgs(
        accountName = accountName,
        dataSetName = dataSetName,
        kind = kind,
        kustoDatabaseResourceId = kustoDatabaseResourceId,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        tableLevelSharingProperties = tableLevelSharingProperties,
    )
}
