@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.ScheduledTriggerArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.RecurrenceInterval
import com.pulumi.azurenative.datashare.kotlin.enums.SynchronizationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A type of trigger based on schedule
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Triggers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledTrigger = new AzureNative.DataShare.ScheduledTrigger("scheduledTrigger", new()
 *     {
 *         AccountName = "Account1",
 *         Kind = "ScheduleBased",
 *         RecurrenceInterval = "Day",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SynchronizationMode = "Incremental",
 *         SynchronizationTime = "2018-11-14T04:47:52.9614956Z",
 *         TriggerName = "Trigger1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewScheduledTrigger(ctx, "scheduledTrigger", &datashare.ScheduledTriggerArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			Kind:                  pulumi.String("ScheduleBased"),
 * 			RecurrenceInterval:    pulumi.String("Day"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SynchronizationMode:   pulumi.String("Incremental"),
 * 			SynchronizationTime:   pulumi.String("2018-11-14T04:47:52.9614956Z"),
 * 			TriggerName:           pulumi.String("Trigger1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ScheduledTrigger;
 * import com.pulumi.azurenative.datashare.ScheduledTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledTrigger = new ScheduledTrigger("scheduledTrigger", ScheduledTriggerArgs.builder()
 *             .accountName("Account1")
 *             .kind("ScheduleBased")
 *             .recurrenceInterval("Day")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .synchronizationMode("Incremental")
 *             .synchronizationTime("2018-11-14T04:47:52.9614956Z")
 *             .triggerName("Trigger1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ScheduledTrigger Trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/triggers/{triggerName}
 * ```
 * @property accountName The name of the share account.
 * @property kind Kind of synchronization on trigger.
 * Expected value is 'ScheduleBased'.
 * @property recurrenceInterval Recurrence Interval
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 * @property synchronizationMode Synchronization mode
 * @property synchronizationTime Synchronization time
 * @property triggerName The name of the trigger.
 */
public data class ScheduledTriggerArgs(
    public val accountName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val recurrenceInterval: Output<Either<String, RecurrenceInterval>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val synchronizationMode: Output<Either<String, SynchronizationMode>>? = null,
    public val synchronizationTime: Output<String>? = null,
    public val triggerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.ScheduledTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.ScheduledTriggerArgs =
        com.pulumi.azurenative.datashare.ScheduledTriggerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .recurrenceInterval(
                recurrenceInterval?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .synchronizationMode(
                synchronizationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .synchronizationTime(synchronizationTime?.applyValue({ args0 -> args0 }))
            .triggerName(triggerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledTriggerArgs].
 */
@PulumiTagMarker
public class ScheduledTriggerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var kind: Output<String>? = null

    private var recurrenceInterval: Output<Either<String, RecurrenceInterval>>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var synchronizationMode: Output<Either<String, SynchronizationMode>>? = null

    private var synchronizationTime: Output<String>? = null

    private var triggerName: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("whwbomvtvdlvegdd")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Kind of synchronization on trigger.
     * Expected value is 'ScheduleBased'.
     */
    @JvmName("ohnrvshvjrvasmtc")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("oplrqdjwhryvelag")
    public suspend fun recurrenceInterval(`value`: Output<Either<String, RecurrenceInterval>>) {
        this.recurrenceInterval = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("mtywpgurhufafnwq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("bhjwedrxgvqpsiuj")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Synchronization mode
     */
    @JvmName("ddtxcbpmijxfpykt")
    public suspend fun synchronizationMode(`value`: Output<Either<String, SynchronizationMode>>) {
        this.synchronizationMode = value
    }

    /**
     * @param value Synchronization time
     */
    @JvmName("rwhgyronefqpnsmm")
    public suspend fun synchronizationTime(`value`: Output<String>) {
        this.synchronizationTime = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("fikwkjmqxwdbeclq")
    public suspend fun triggerName(`value`: Output<String>) {
        this.triggerName = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("jaennupwdgtprjvh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Kind of synchronization on trigger.
     * Expected value is 'ScheduleBased'.
     */
    @JvmName("fuvewgwiwrcjcdmy")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("joyyuyphqxyslice")
    public suspend fun recurrenceInterval(`value`: Either<String, RecurrenceInterval>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("yksjliqelleqeldi")
    public fun recurrenceInterval(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceInterval>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value Recurrence Interval
     */
    @JvmName("cxrukggorqoedlyw")
    public fun recurrenceInterval(`value`: RecurrenceInterval) {
        val toBeMapped = Either.ofRight<String, RecurrenceInterval>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceInterval = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("emrcdfbbjbvixvog")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("oqciawfxmvihevwc")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Synchronization mode
     */
    @JvmName("truphqymqmboilcj")
    public suspend fun synchronizationMode(`value`: Either<String, SynchronizationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationMode = mapped
    }

    /**
     * @param value Synchronization mode
     */
    @JvmName("fwwkvialhacealgv")
    public fun synchronizationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SynchronizationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.synchronizationMode = mapped
    }

    /**
     * @param value Synchronization mode
     */
    @JvmName("rwclxcaidxutyyck")
    public fun synchronizationMode(`value`: SynchronizationMode) {
        val toBeMapped = Either.ofRight<String, SynchronizationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.synchronizationMode = mapped
    }

    /**
     * @param value Synchronization time
     */
    @JvmName("jhyimlsqjvfwouwh")
    public suspend fun synchronizationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationTime = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("lyanjljjlfnhqetl")
    public suspend fun triggerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerName = mapped
    }

    internal fun build(): ScheduledTriggerArgs = ScheduledTriggerArgs(
        accountName = accountName,
        kind = kind,
        recurrenceInterval = recurrenceInterval,
        resourceGroupName = resourceGroupName,
        shareSubscriptionName = shareSubscriptionName,
        synchronizationMode = synchronizationMode,
        synchronizationTime = synchronizationTime,
        triggerName = triggerName,
    )
}
