@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Share].
 */
@PulumiTagMarker
public class ShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ShareArgs = ShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ShareArgsBuilder.() -> Unit) {
        val builder = ShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Share {
        val builtJavaResource = com.pulumi.azurenative.datashare.Share(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Share(builtJavaResource)
    }
}

/**
 * A share data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Shares_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var share = new AzureNative.DataShare.Share("share", new()
 *     {
 *         AccountName = "Account1",
 *         Description = "share description",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareKind = "CopyBased",
 *         ShareName = "Share1",
 *         Terms = "Confidential",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewShare(ctx, "share", &datashare.ShareArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			Description:       pulumi.String("share description"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareKind:         pulumi.String("CopyBased"),
 * 			ShareName:         pulumi.String("Share1"),
 * 			Terms:             pulumi.String("Confidential"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.Share;
 * import com.pulumi.azurenative.datashare.ShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var share = new Share("share", ShareArgs.builder()
 *             .accountName("Account1")
 *             .description("share description")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareKind("CopyBased")
 *             .shareName("Share1")
 *             .terms("Confidential")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:Share Share1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}
 * ```
 */
public class Share internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.Share,
) : KotlinCustomResource(javaResource, ShareMapper) {
    /**
     * Time at which the share was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Share description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Share kind.
     */
    public val shareKind: Output<String>?
        get() = javaResource.shareKind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Share terms.
     */
    public val terms: Output<String>?
        get() = javaResource.terms().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Email of the user who created the resource
     */
    public val userEmail: Output<String>
        get() = javaResource.userEmail().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the resource
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ShareMapper : ResourceMapper<Share> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.Share::class == javaResource::class

    override fun map(javaResource: Resource): Share = Share(
        javaResource as
            com.pulumi.azurenative.datashare.Share,
    )
}

/**
 * @see [Share].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Share].
 */
public suspend fun share(name: String, block: suspend ShareResourceBuilder.() -> Unit): Share {
    val builder = ShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Share].
 * @param name The _unique_ name of the resulting resource.
 */
public fun share(name: String): Share {
    val builder = ShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
