@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A SQL DW Table data set mapping.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSetMapping = new AzureNative.DataShare.SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSetMapping(ctx, "sqlDWTableDataSetMapping", &datashare.SqlDWTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSetMapping = new SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", SqlDWTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSetMapping = new AzureNative.DataShare.SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSetMapping(ctx, "sqlDWTableDataSetMapping", &datashare.SqlDWTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSetMapping = new SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", SqlDWTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSetMapping = new AzureNative.DataShare.SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSetMapping(ctx, "sqlDWTableDataSetMapping", &datashare.SqlDWTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSetMapping = new SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", SqlDWTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSetMapping = new AzureNative.DataShare.SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetId = "a08f184b-0567-4b11-ba22-a1199336d226",
 *         DataSetMappingName = "DatasetMapping1",
 *         DataWarehouseName = "DataWarehouse1",
 *         Kind = "SqlDWTable",
 *         ResourceGroupName = "SampleResourceGroup",
 *         SchemaName = "dbo",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SqlServerResourceId = "/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1",
 *         TableName = "Table1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSetMapping(ctx, "sqlDWTableDataSetMapping", &datashare.SqlDWTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetId:             pulumi.String("a08f184b-0567-4b11-ba22-a1199336d226"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			DataWarehouseName:     pulumi.String("DataWarehouse1"),
 * 			Kind:                  pulumi.String("SqlDWTable"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			SchemaName:            pulumi.String("dbo"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SqlServerResourceId:   pulumi.String("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
 * 			TableName:             pulumi.String("Table1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSetMapping = new SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", SqlDWTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetId("a08f184b-0567-4b11-ba22-a1199336d226")
 *             .dataSetMappingName("DatasetMapping1")
 *             .dataWarehouseName("DataWarehouse1")
 *             .kind("SqlDWTable")
 *             .resourceGroupName("SampleResourceGroup")
 *             .schemaName("dbo")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .sqlServerResourceId("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1")
 *             .tableName("Table1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDWTableDataSetMapping = new AzureNative.DataShare.SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDWTableDataSetMapping(ctx, "sqlDWTableDataSetMapping", &datashare.SqlDWTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDWTableDataSetMapping = new SqlDWTableDataSetMapping("sqlDWTableDataSetMapping", SqlDWTableDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:SqlDWTableDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingName The name of the data set mapping to be created.
 * @property dataWarehouseName DataWarehouse name of the source data set
 * @property kind Kind of data set mapping.
 * Expected value is 'SqlDWTable'.
 * @property resourceGroupName The resource group name.
 * @property schemaName Schema of the table. Default value is dbo.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 * @property sqlServerResourceId Resource id of SQL server
 * @property tableName SQL DW table name.
 */
public data class SqlDWTableDataSetMappingArgs(
    public val accountName: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetMappingName: Output<String>? = null,
    public val dataWarehouseName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
    public val sqlServerResourceId: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs =
        com.pulumi.azurenative.datashare.SqlDWTableDataSetMappingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName?.applyValue({ args0 -> args0 }))
            .dataWarehouseName(dataWarehouseName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 }))
            .sqlServerResourceId(sqlServerResourceId?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlDWTableDataSetMappingArgs].
 */
@PulumiTagMarker
public class SqlDWTableDataSetMappingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetMappingName: Output<String>? = null

    private var dataWarehouseName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    private var sqlServerResourceId: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("yfirxqiypybuxbyv")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("rwwwcuvujhjrbsbm")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("flfwiyfqwmshaqin")
    public suspend fun dataSetMappingName(`value`: Output<String>) {
        this.dataSetMappingName = value
    }

    /**
     * @param value DataWarehouse name of the source data set
     */
    @JvmName("tacpspgnepnbqwrc")
    public suspend fun dataWarehouseName(`value`: Output<String>) {
        this.dataWarehouseName = value
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'SqlDWTable'.
     */
    @JvmName("ofassfbxgewbghkd")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ogayengidujymysj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schema of the table. Default value is dbo.
     */
    @JvmName("xlyqkvqmysebpyox")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("lncdxtaopnyejgec")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value Resource id of SQL server
     */
    @JvmName("wbjskltpxbagcqcg")
    public suspend fun sqlServerResourceId(`value`: Output<String>) {
        this.sqlServerResourceId = value
    }

    /**
     * @param value SQL DW table name.
     */
    @JvmName("jqocyacjybrgghsu")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("ttwreorpwrypndtx")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("fccnotubigaoryaa")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("djulwfucohqfbwan")
    public suspend fun dataSetMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value DataWarehouse name of the source data set
     */
    @JvmName("hbephcrolwchgmmo")
    public suspend fun dataWarehouseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataWarehouseName = mapped
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'SqlDWTable'.
     */
    @JvmName("nhqnokbjlaiqpfct")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("fpqjrcoewruwpmxo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema of the table. Default value is dbo.
     */
    @JvmName("amuqgpyykkpnbteh")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("lbihbcjasgqytgbv")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Resource id of SQL server
     */
    @JvmName("posuqduqkniahgpm")
    public suspend fun sqlServerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerResourceId = mapped
    }

    /**
     * @param value SQL DW table name.
     */
    @JvmName("asvqisoergcpggla")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): SqlDWTableDataSetMappingArgs = SqlDWTableDataSetMappingArgs(
        accountName = accountName,
        dataSetId = dataSetId,
        dataSetMappingName = dataSetMappingName,
        dataWarehouseName = dataWarehouseName,
        kind = kind,
        resourceGroupName = resourceGroupName,
        schemaName = schemaName,
        shareSubscriptionName = shareSubscriptionName,
        sqlServerResourceId = sqlServerResourceId,
        tableName = tableName,
    )
}
