@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetADLSGen2FileSystemDataSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 */
public data class GetADLSGen2FileSystemDataSetPlainArgs(
    public val accountName: String,
    public val dataSetName: String,
    public val resourceGroupName: String,
    public val shareName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetADLSGen2FileSystemDataSetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.GetADLSGen2FileSystemDataSetPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetADLSGen2FileSystemDataSetPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .dataSetName(dataSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetADLSGen2FileSystemDataSetPlainArgs].
 */
@PulumiTagMarker
public class GetADLSGen2FileSystemDataSetPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var dataSetName: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("grqjajyqmshoenjh")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("sxbkgoqfsyauqqbl")
    public suspend fun dataSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataSetName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tcildsykxjlrtwrx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("fwonvdgurqntplyv")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    internal fun build(): GetADLSGen2FileSystemDataSetPlainArgs =
        GetADLSGen2FileSystemDataSetPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            dataSetName = dataSetName ?: throw PulumiNullFieldException("dataSetName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareName = shareName ?: throw PulumiNullFieldException("shareName"),
        )
}
