@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.IdentityArgs.builder
import com.pulumi.azurenative.datashare.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity of resource
 * @property type Identity Type
 */
public data class IdentityArgs(
    public val type: Output<Either<String, Type>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.IdentityArgs =
        com.pulumi.azurenative.datashare.inputs.IdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value Identity Type
     */
    @JvmName("nohggsidodqctwbn")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value Identity Type
     */
    @JvmName("fnohbatrxedolgwt")
    public suspend fun type(`value`: Either<String, Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Type
     */
    @JvmName("qfbvsagnuvjlhfhb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Type
     */
    @JvmName("qexvgahqdbdsibdv")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
    )
}
