@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Blob data set mapping.
 * @property containerName Container that has the file path.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingStatus Gets the status of the data set mapping.
 * @property filePath File path within the source data set
 * @property id The resource id of the azure resource
 * @property kind Kind of data set mapping.
 * Expected value is 'Blob'.
 * @property name Name of the azure resource
 * @property outputType File output type
 * @property provisioningState Provisioning state of the data set mapping.
 * @property resourceGroup Resource group of storage account.
 * @property storageAccountName Storage account name of the source data set.
 * @property subscriptionId Subscription id of storage account.
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetBlobDataSetMappingResult(
    public val containerName: String,
    public val dataSetId: String,
    public val dataSetMappingStatus: String,
    public val filePath: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val outputType: String? = null,
    public val provisioningState: String,
    public val resourceGroup: String,
    public val storageAccountName: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetBlobDataSetMappingResult):
            GetBlobDataSetMappingResult = GetBlobDataSetMappingResult(
            containerName = javaType.containerName(),
            dataSetId = javaType.dataSetId(),
            dataSetMappingStatus = javaType.dataSetMappingStatus(),
            filePath = javaType.filePath(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            outputType = javaType.outputType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGroup = javaType.resourceGroup(),
            storageAccountName = javaType.storageAccountName(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
