@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A kusto database data set.
 * @property dataSetId Unique id for identifying a data set resource
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'KustoDatabase'.
 * @property kustoDatabaseResourceId Resource id of the kusto database.
 * @property location Location of the kusto cluster.
 * @property name Name of the azure resource
 * @property provisioningState Provisioning state of the kusto database data set.
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetKustoDatabaseDataSetResult(
    public val dataSetId: String,
    public val id: String,
    public val kind: String,
    public val kustoDatabaseResourceId: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetKustoDatabaseDataSetResult):
            GetKustoDatabaseDataSetResult = GetKustoDatabaseDataSetResult(
            dataSetId = javaType.dataSetId(),
            id = javaType.id(),
            kind = javaType.kind(),
            kustoDatabaseResourceId = javaType.kustoDatabaseResourceId(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
