@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A consumer side list of share subscription synchronizations
 * @property nextLink The Url of next result page.
 * @property value Collection of items of type DataTransferObjects.
 */
public data class ListShareSubscriptionSynchronizationsResult(
    public val nextLink: String? = null,
    public val `value`: List<ShareSubscriptionSynchronizationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.ListShareSubscriptionSynchronizationsResult):
            ListShareSubscriptionSynchronizationsResult = ListShareSubscriptionSynchronizationsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datashare.kotlin.outputs.ShareSubscriptionSynchronizationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
