@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Database].
 */
@PulumiTagMarker
public class DatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseArgs = DatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseArgsBuilder.() -> Unit) {
        val builder = DatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Database {
        val builtJavaResource = com.pulumi.azurenative.dbformariadb.Database(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Database(builtJavaResource)
    }
}

/**
 * Represents a Database.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### DatabaseCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.DBforMariaDB.Database("database", new()
 *     {
 *         Charset = "utf8",
 *         Collation = "utf8_general_ci",
 *         DatabaseName = "db1",
 *         ResourceGroupName = "TestGroup",
 *         ServerName = "testserver",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewDatabase(ctx, "database", &dbformariadb.DatabaseArgs{
 * 			Charset:           pulumi.String("utf8"),
 * 			Collation:         pulumi.String("utf8_general_ci"),
 * 			DatabaseName:      pulumi.String("db1"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Database;
 * import com.pulumi.azurenative.dbformariadb.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .charset("utf8")
 *             .collation("utf8_general_ci")
 *             .databaseName("db1")
 *             .resourceGroupName("TestGroup")
 *             .serverName("testserver")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:Database db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}/databases/{databaseName}
 * ```
 */
public class Database internal constructor(
    override val javaResource: com.pulumi.azurenative.dbformariadb.Database,
) : KotlinCustomResource(javaResource, DatabaseMapper) {
    /**
     * The charset of the database.
     */
    public val charset: Output<String>?
        get() = javaResource.charset().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The collation of the database.
     */
    public val collation: Output<String>?
        get() = javaResource.collation().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseMapper : ResourceMapper<Database> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbformariadb.Database::class == javaResource::class

    override fun map(javaResource: Resource): Database = Database(
        javaResource as
            com.pulumi.azurenative.dbformariadb.Database,
    )
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Database].
 */
public suspend fun database(name: String, block: suspend DatabaseResourceBuilder.() -> Unit):
    Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 */
public fun database(name: String): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
