@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.kotlin.outputs.ServerPrivateEndpointConnectionResponse
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.StorageProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.ServerPrivateEndpointConnectionResponse.Companion.toKotlin as serverPrivateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.dbformariadb.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin

/**
 * Builder for [Server].
 */
@PulumiTagMarker
public class ServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerArgs = ServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerArgsBuilder.() -> Unit) {
        val builder = ServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Server {
        val builtJavaResource = com.pulumi.azurenative.dbformariadb.Server(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Server(builtJavaResource)
    }
}

/**
 * Represents a server.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### Create a database as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "brazilsouth",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForRestoreArgs
 *         {
 *             CreateMode = "PointInTimeRestore",
 *             RestorePointInTime = "2017-12-14T00:00:37.467Z",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("brazilsouth"),
 * 			Properties: dbformariadb.ServerPropertiesForRestore{
 * 				CreateMode:         "PointInTimeRestore",
 * 				RestorePointInTime: "2017-12-14T00:00:37.467Z",
 * 				SourceServerId:     "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("brazilsouth")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "PointInTimeRestore"),
 *                 Map.entry("restorePointInTime", "2017-12-14T00:00:37.467Z"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForDefaultCreateArgs
 *         {
 *             AdministratorLogin = "cloudsa",
 *             AdministratorLoginPassword = "<administratorLoginPassword>",
 *             CreateMode = "Default",
 *             MinimalTlsVersion = "TLS1_2",
 *             SslEnforcement = AzureNative.DBforMariaDB.SslEnforcementEnum.Enabled,
 *             StorageProfile = new AzureNative.DBforMariaDB.Inputs.StorageProfileArgs
 *             {
 *                 BackupRetentionDays = 7,
 *                 GeoRedundantBackup = "Enabled",
 *                 StorageMB = 128000,
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "mariadbtestsvc4",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForDefaultCreate{
 * 				AdministratorLogin:         "cloudsa",
 * 				AdministratorLoginPassword: "<administratorLoginPassword>",
 * 				CreateMode:                 "Default",
 * 				MinimalTlsVersion:          "TLS1_2",
 * 				SslEnforcement:             dbformariadb.SslEnforcementEnumEnabled,
 * 				StorageProfile: dbformariadb.StorageProfile{
 * 					BackupRetentionDays: 7,
 * 					GeoRedundantBackup:  "Enabled",
 * 					StorageMB:           128000,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("mariadbtestsvc4"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("administratorLogin", "cloudsa"),
 *                 Map.entry("administratorLoginPassword", "<administratorLoginPassword>"),
 *                 Map.entry("createMode", "Default"),
 *                 Map.entry("minimalTlsVersion", "TLS1_2"),
 *                 Map.entry("sslEnforcement", "Enabled"),
 *                 Map.entry("storageProfile", Map.ofEntries(
 *                     Map.entry("backupRetentionDays", 7),
 *                     Map.entry("geoRedundantBackup", "Enabled"),
 *                     Map.entry("storageMB", 128000)
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .serverName("mariadbtestsvc4")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a replica server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForReplicaArgs
 *         {
 *             CreateMode = "Replica",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForReplica{
 * 				CreateMode:     "Replica",
 * 				SourceServerId: "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "Replica"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server as a geo restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForGeoRestoreArgs
 *         {
 *             CreateMode = "GeoRestore",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForGeoRestore{
 * 				CreateMode:     "GeoRestore",
 * 				SourceServerId: "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "GeoRestore"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:Server targetserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}
 * ```
 */
public class Server internal constructor(
    override val javaResource: com.pulumi.azurenative.dbformariadb.Server,
) : KotlinCustomResource(javaResource, ServerMapper) {
    /**
     * The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Earliest restore point creation time (ISO8601 format)
     */
    public val earliestRestoreDate: Output<String>?
        get() = javaResource.earliestRestoreDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The fully qualified domain name of a server.
     */
    public val fullyQualifiedDomainName: Output<String>?
        get() = javaResource.fullyQualifiedDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The master server id of a replica server.
     */
    public val masterServerId: Output<String>?
        get() = javaResource.masterServerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enforce a minimal Tls version for the server.
     */
    public val minimalTlsVersion: Output<String>?
        get() = javaResource.minimalTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections on a server
     */
    public val privateEndpointConnections: Output<List<ServerPrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverPrivateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of replicas that a master server can have.
     */
    public val replicaCapacity: Output<Int>?
        get() = javaResource.replicaCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The replication role of the server.
     */
    public val replicationRole: Output<String>?
        get() = javaResource.replicationRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU (pricing tier) of the server.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Enable ssl enforcement or not when connect to server.
     */
    public val sslEnforcement: Output<String>?
        get() = javaResource.sslEnforcement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage profile of a server.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A state of a server that is visible to user.
     */
    public val userVisibleState: Output<String>?
        get() = javaResource.userVisibleState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServerMapper : ResourceMapper<Server> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbformariadb.Server::class == javaResource::class

    override fun map(javaResource: Resource): Server = Server(
        javaResource as
            com.pulumi.azurenative.dbformariadb.Server,
    )
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Server].
 */
public suspend fun server(name: String, block: suspend ServerResourceBuilder.() -> Unit): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 */
public fun server(name: String): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
