@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.ServerArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a server.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### Create a database as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "brazilsouth",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForRestoreArgs
 *         {
 *             CreateMode = "PointInTimeRestore",
 *             RestorePointInTime = "2017-12-14T00:00:37.467Z",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("brazilsouth"),
 * 			Properties: dbformariadb.ServerPropertiesForRestore{
 * 				CreateMode:         "PointInTimeRestore",
 * 				RestorePointInTime: "2017-12-14T00:00:37.467Z",
 * 				SourceServerId:     "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("brazilsouth")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "PointInTimeRestore"),
 *                 Map.entry("restorePointInTime", "2017-12-14T00:00:37.467Z"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForDefaultCreateArgs
 *         {
 *             AdministratorLogin = "cloudsa",
 *             AdministratorLoginPassword = "<administratorLoginPassword>",
 *             CreateMode = "Default",
 *             MinimalTlsVersion = "TLS1_2",
 *             SslEnforcement = AzureNative.DBforMariaDB.SslEnforcementEnum.Enabled,
 *             StorageProfile = new AzureNative.DBforMariaDB.Inputs.StorageProfileArgs
 *             {
 *                 BackupRetentionDays = 7,
 *                 GeoRedundantBackup = "Enabled",
 *                 StorageMB = 128000,
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "mariadbtestsvc4",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForDefaultCreate{
 * 				AdministratorLogin:         "cloudsa",
 * 				AdministratorLoginPassword: "<administratorLoginPassword>",
 * 				CreateMode:                 "Default",
 * 				MinimalTlsVersion:          "TLS1_2",
 * 				SslEnforcement:             dbformariadb.SslEnforcementEnumEnabled,
 * 				StorageProfile: dbformariadb.StorageProfile{
 * 					BackupRetentionDays: 7,
 * 					GeoRedundantBackup:  "Enabled",
 * 					StorageMB:           128000,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("mariadbtestsvc4"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("administratorLogin", "cloudsa"),
 *                 Map.entry("administratorLoginPassword", "<administratorLoginPassword>"),
 *                 Map.entry("createMode", "Default"),
 *                 Map.entry("minimalTlsVersion", "TLS1_2"),
 *                 Map.entry("sslEnforcement", "Enabled"),
 *                 Map.entry("storageProfile", Map.ofEntries(
 *                     Map.entry("backupRetentionDays", 7),
 *                     Map.entry("geoRedundantBackup", "Enabled"),
 *                     Map.entry("storageMB", 128000)
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .serverName("mariadbtestsvc4")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a replica server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForReplicaArgs
 *         {
 *             CreateMode = "Replica",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForReplica{
 * 				CreateMode:     "Replica",
 * 				SourceServerId: "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "Replica"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/MasterResourceGroup/providers/Microsoft.DBforMariaDB/servers/masterserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server as a geo restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMariaDB.Server("server", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.DBforMariaDB.Inputs.ServerPropertiesForGeoRestoreArgs
 *         {
 *             CreateMode = "GeoRestore",
 *             SourceServerId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 *         },
 *         ResourceGroupName = "TargetResourceGroup",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMariaDB.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen5",
 *             Name = "GP_Gen5_2",
 *             Tier = "GeneralPurpose",
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewServer(ctx, "server", &dbformariadb.ServerArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: dbformariadb.ServerPropertiesForGeoRestore{
 * 				CreateMode:     "GeoRestore",
 * 				SourceServerId: "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver",
 * 			},
 * 			ResourceGroupName: pulumi.String("TargetResourceGroup"),
 * 			ServerName:        pulumi.String("targetserver"),
 * 			Sku: &dbformariadb.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen5"),
 * 				Name:     pulumi.String("GP_Gen5_2"),
 * 				Tier:     pulumi.String("GeneralPurpose"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.Server;
 * import com.pulumi.azurenative.dbformariadb.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("createMode", "GeoRestore"),
 *                 Map.entry("sourceServerId", "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMariaDB/servers/sourceserver")
 *             ))
 *             .resourceGroupName("TargetResourceGroup")
 *             .serverName("targetserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5_2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .tags(Map.of("ElasticServer", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:Server targetserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}
 * ```
 * @property location The location the resource resides in.
 * @property properties Properties of the server.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property sku The SKU (pricing tier) of the server.
 * @property tags Application-specific metadata in the form of key-value pairs.
 */
public data class ServerArgs(
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.ServerArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.ServerArgs =
        com.pulumi.azurenative.dbformariadb.ServerArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServerArgs].
 */
@PulumiTagMarker
public class ServerArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The location the resource resides in.
     */
    @JvmName("hlvguejmfcuaybqn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the server.
     */
    @JvmName("euykgtgdbaydsass")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jawhxulpdqmjlgbd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("qwfenhbvpogsioqs")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("ukjfkubsbbttbvxy")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Application-specific metadata in the form of key-value pairs.
     */
    @JvmName("fmqbhfblthvcqjmo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The location the resource resides in.
     */
    @JvmName("agvmdslrbtbuqxkr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the server.
     */
    @JvmName("anrveacuchmwcrsg")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fcfchstktwaegkea")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dnxfcggnfdjtvkxi")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("elsvnfmfocpypigo")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU (pricing tier) of the server.
     */
    @JvmName("hcavxuyliaddbksi")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Application-specific metadata in the form of key-value pairs.
     */
    @JvmName("bvsqloskjbtbkdyl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Application-specific metadata in the form of key-value pairs.
     */
    @JvmName("qjahiwcywnxjsmik")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServerArgs = ServerArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sku = sku,
        tags = tags,
    )
}
