@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a server.
 * @property administratorLogin The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
 * @property earliestRestoreDate Earliest restore point creation time (ISO8601 format)
 * @property fullyQualifiedDomainName The fully qualified domain name of a server.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property masterServerId The master server id of a replica server.
 * @property minimalTlsVersion Enforce a minimal Tls version for the server.
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections on a server
 * @property publicNetworkAccess Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property replicaCapacity The maximum number of replicas that a master server can have.
 * @property replicationRole The replication role of the server.
 * @property sku The SKU (pricing tier) of the server.
 * @property sslEnforcement Enable ssl enforcement or not when connect to server.
 * @property storageProfile Storage profile of a server.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userVisibleState A state of a server that is visible to user.
 * @property version Server version.
 */
public data class GetServerResult(
    public val administratorLogin: String? = null,
    public val earliestRestoreDate: String? = null,
    public val fullyQualifiedDomainName: String? = null,
    public val id: String,
    public val location: String,
    public val masterServerId: String? = null,
    public val minimalTlsVersion: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<ServerPrivateEndpointConnectionResponse>,
    public val publicNetworkAccess: String? = null,
    public val replicaCapacity: Int? = null,
    public val replicationRole: String? = null,
    public val sku: SkuResponse? = null,
    public val sslEnforcement: String? = null,
    public val storageProfile: StorageProfileResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userVisibleState: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.GetServerResult):
            GetServerResult = GetServerResult(
            administratorLogin = javaType.administratorLogin().map({ args0 -> args0 }).orElse(null),
            earliestRestoreDate = javaType.earliestRestoreDate().map({ args0 -> args0 }).orElse(null),
            fullyQualifiedDomainName = javaType.fullyQualifiedDomainName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            masterServerId = javaType.masterServerId().map({ args0 -> args0 }).orElse(null),
            minimalTlsVersion = javaType.minimalTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformariadb.kotlin.outputs.ServerPrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            replicaCapacity = javaType.replicaCapacity().map({ args0 -> args0 }).orElse(null),
            replicationRole = javaType.replicationRole().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformariadb.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sslEnforcement = javaType.sslEnforcement().map({ args0 -> args0 }).orElse(null),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbformariadb.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userVisibleState = javaType.userVisibleState().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
