@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.StorageArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.EnableStatusEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage Profile properties of a server
 * @property autoGrow Enable Storage Auto Grow or not.
 * @property autoIoScaling Enable IO Auto Scaling or not.
 * @property iops Storage IOPS for a server.
 * @property logOnDisk Enable Log On Disk or not.
 * @property storageSizeGB Max storage size allowed for a server.
 */
public data class StorageArgs(
    public val autoGrow: Output<Either<String, EnableStatusEnum>>? = null,
    public val autoIoScaling: Output<Either<String, EnableStatusEnum>>? = null,
    public val iops: Output<Int>? = null,
    public val logOnDisk: Output<Either<String, EnableStatusEnum>>? = null,
    public val storageSizeGB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.StorageArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.StorageArgs =
        com.pulumi.azurenative.dbformysql.inputs.StorageArgs.builder()
            .autoGrow(
                autoGrow?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoIoScaling(
                autoIoScaling?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .iops(iops?.applyValue({ args0 -> args0 }))
            .logOnDisk(
                logOnDisk?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageSizeGB(storageSizeGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageArgs].
 */
@PulumiTagMarker
public class StorageArgsBuilder internal constructor() {
    private var autoGrow: Output<Either<String, EnableStatusEnum>>? = null

    private var autoIoScaling: Output<Either<String, EnableStatusEnum>>? = null

    private var iops: Output<Int>? = null

    private var logOnDisk: Output<Either<String, EnableStatusEnum>>? = null

    private var storageSizeGB: Output<Int>? = null

    /**
     * @param value Enable Storage Auto Grow or not.
     */
    @JvmName("kfsfomafqsqvsnbc")
    public suspend fun autoGrow(`value`: Output<Either<String, EnableStatusEnum>>) {
        this.autoGrow = value
    }

    /**
     * @param value Enable IO Auto Scaling or not.
     */
    @JvmName("viohgcpcugubfkdy")
    public suspend fun autoIoScaling(`value`: Output<Either<String, EnableStatusEnum>>) {
        this.autoIoScaling = value
    }

    /**
     * @param value Storage IOPS for a server.
     */
    @JvmName("duvynstiepyaycns")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Enable Log On Disk or not.
     */
    @JvmName("ifohobmoiwxuvapy")
    public suspend fun logOnDisk(`value`: Output<Either<String, EnableStatusEnum>>) {
        this.logOnDisk = value
    }

    /**
     * @param value Max storage size allowed for a server.
     */
    @JvmName("fxgasdnihpxjmoxw")
    public suspend fun storageSizeGB(`value`: Output<Int>) {
        this.storageSizeGB = value
    }

    /**
     * @param value Enable Storage Auto Grow or not.
     */
    @JvmName("grdnjxbaytvypocd")
    public suspend fun autoGrow(`value`: Either<String, EnableStatusEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGrow = mapped
    }

    /**
     * @param value Enable Storage Auto Grow or not.
     */
    @JvmName("sojwfxugnbotfmrh")
    public fun autoGrow(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGrow = mapped
    }

    /**
     * @param value Enable Storage Auto Grow or not.
     */
    @JvmName("bmrptcfjriqhkplo")
    public fun autoGrow(`value`: EnableStatusEnum) {
        val toBeMapped = Either.ofRight<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGrow = mapped
    }

    /**
     * @param value Enable IO Auto Scaling or not.
     */
    @JvmName("valjtqbvjoqfnyts")
    public suspend fun autoIoScaling(`value`: Either<String, EnableStatusEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoIoScaling = mapped
    }

    /**
     * @param value Enable IO Auto Scaling or not.
     */
    @JvmName("tecjgrkthadllwob")
    public fun autoIoScaling(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoIoScaling = mapped
    }

    /**
     * @param value Enable IO Auto Scaling or not.
     */
    @JvmName("tdfrqjkmaphibggm")
    public fun autoIoScaling(`value`: EnableStatusEnum) {
        val toBeMapped = Either.ofRight<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoIoScaling = mapped
    }

    /**
     * @param value Storage IOPS for a server.
     */
    @JvmName("veksydanjlyqxhdv")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Enable Log On Disk or not.
     */
    @JvmName("ocwqbusexcocltoo")
    public suspend fun logOnDisk(`value`: Either<String, EnableStatusEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logOnDisk = mapped
    }

    /**
     * @param value Enable Log On Disk or not.
     */
    @JvmName("csyeqojmcnotrhlb")
    public fun logOnDisk(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logOnDisk = mapped
    }

    /**
     * @param value Enable Log On Disk or not.
     */
    @JvmName("alkupuvlrokhgwuo")
    public fun logOnDisk(`value`: EnableStatusEnum) {
        val toBeMapped = Either.ofRight<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logOnDisk = mapped
    }

    /**
     * @param value Max storage size allowed for a server.
     */
    @JvmName("ycvkwusfxwxircfs")
    public suspend fun storageSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSizeGB = mapped
    }

    internal fun build(): StorageArgs = StorageArgs(
        autoGrow = autoGrow,
        autoIoScaling = autoIoScaling,
        iops = iops,
        logOnDisk = logOnDisk,
        storageSizeGB = storageSizeGB,
    )
}
