@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VirtualEndpoint].
 */
@PulumiTagMarker
public class VirtualEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualEndpointArgs = VirtualEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualEndpointArgsBuilder.() -> Unit) {
        val builder = VirtualEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualEndpoint(builtJavaResource)
    }
}

/**
 * Represents a virtual endpoint for a server.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### Create a new virtual endpoint for a flexible server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualEndpoint = new AzureNative.DBforPostgreSQL.VirtualEndpoint("virtualEndpoint", new()
 *     {
 *         EndpointType = "ReadWrite",
 *         Members = new[]
 *         {
 *             "testPrimary1",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         VirtualEndpointName = "pgVirtualEndpoint1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewVirtualEndpoint(ctx, "virtualEndpoint", &dbforpostgresql.VirtualEndpointArgs{
 * 			EndpointType: pulumi.String("ReadWrite"),
 * 			Members: pulumi.StringArray{
 * 				pulumi.String("testPrimary1"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("testrg"),
 * 			ServerName:          pulumi.String("pgtestsvc4"),
 * 			VirtualEndpointName: pulumi.String("pgVirtualEndpoint1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint;
 * import com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualEndpoint = new VirtualEndpoint("virtualEndpoint", VirtualEndpointArgs.builder()
 *             .endpointType("ReadWrite")
 *             .members("testPrimary1")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .virtualEndpointName("pgVirtualEndpoint1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:VirtualEndpoint pgVirtualEndpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/virtualendpoints/{virtualEndpointName}
 * ```
 */
public class VirtualEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint,
) : KotlinCustomResource(javaResource, VirtualEndpointMapper) {
    /**
     * The endpoint type for the virtual endpoint.
     */
    public val endpointType: Output<String>?
        get() = javaResource.endpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of members for a virtual endpoint
     */
    public val members: Output<List<String>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of virtual endpoints for a server
     */
    public val virtualEndpoints: Output<List<String>>
        get() = javaResource.virtualEndpoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object VirtualEndpointMapper : ResourceMapper<VirtualEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): VirtualEndpoint = VirtualEndpoint(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint,
    )
}

/**
 * @see [VirtualEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualEndpoint].
 */
public suspend fun virtualEndpoint(
    name: String,
    block: suspend VirtualEndpointResourceBuilder.() -> Unit,
): VirtualEndpoint {
    val builder = VirtualEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualEndpoint(name: String): VirtualEndpoint {
    val builder = VirtualEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
