@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Server admin credentials.
 * @property sourceServerPassword Password for source server.
 * @property targetServerPassword Password for target server.
 */
public data class AdminCredentialsArgs(
    public val sourceServerPassword: Output<String>,
    public val targetServerPassword: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs.builder()
            .sourceServerPassword(sourceServerPassword.applyValue({ args0 -> args0 }))
            .targetServerPassword(targetServerPassword.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdminCredentialsArgs].
 */
@PulumiTagMarker
public class AdminCredentialsArgsBuilder internal constructor() {
    private var sourceServerPassword: Output<String>? = null

    private var targetServerPassword: Output<String>? = null

    /**
     * @param value Password for source server.
     */
    @JvmName("clwbxfeibckpkedr")
    public suspend fun sourceServerPassword(`value`: Output<String>) {
        this.sourceServerPassword = value
    }

    /**
     * @param value Password for target server.
     */
    @JvmName("yustytesqgnrioyc")
    public suspend fun targetServerPassword(`value`: Output<String>) {
        this.targetServerPassword = value
    }

    /**
     * @param value Password for source server.
     */
    @JvmName("tnwfyqnpxsjfxmgx")
    public suspend fun sourceServerPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceServerPassword = mapped
    }

    /**
     * @param value Password for target server.
     */
    @JvmName("vymhwoytctisssao")
    public suspend fun targetServerPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetServerPassword = mapped
    }

    internal fun build(): AdminCredentialsArgs = AdminCredentialsArgs(
        sourceServerPassword = sourceServerPassword ?: throw
            PulumiNullFieldException("sourceServerPassword"),
        targetServerPassword = targetServerPassword ?: throw
            PulumiNullFieldException("targetServerPassword"),
    )
}
