@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.MaintenanceWindowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Maintenance window properties of a server.
 * @property customWindow indicates whether custom window is enabled or disabled
 * @property dayOfWeek day of week for maintenance window
 * @property startHour start hour for maintenance window
 * @property startMinute start minute for maintenance window
 */
public data class MaintenanceWindowArgs(
    public val customWindow: Output<String>? = null,
    public val dayOfWeek: Output<Int>? = null,
    public val startHour: Output<Int>? = null,
    public val startMinute: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.MaintenanceWindowArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.MaintenanceWindowArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.MaintenanceWindowArgs.builder()
            .customWindow(customWindow?.applyValue({ args0 -> args0 }))
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0 }))
            .startHour(startHour?.applyValue({ args0 -> args0 }))
            .startMinute(startMinute?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowArgsBuilder internal constructor() {
    private var customWindow: Output<String>? = null

    private var dayOfWeek: Output<Int>? = null

    private var startHour: Output<Int>? = null

    private var startMinute: Output<Int>? = null

    /**
     * @param value indicates whether custom window is enabled or disabled
     */
    @JvmName("qvptceopirxtbuvn")
    public suspend fun customWindow(`value`: Output<String>) {
        this.customWindow = value
    }

    /**
     * @param value day of week for maintenance window
     */
    @JvmName("jqoqxowtvbvhjbym")
    public suspend fun dayOfWeek(`value`: Output<Int>) {
        this.dayOfWeek = value
    }

    /**
     * @param value start hour for maintenance window
     */
    @JvmName("lsgtaroigivlgwne")
    public suspend fun startHour(`value`: Output<Int>) {
        this.startHour = value
    }

    /**
     * @param value start minute for maintenance window
     */
    @JvmName("kfnownklxkfblhad")
    public suspend fun startMinute(`value`: Output<Int>) {
        this.startMinute = value
    }

    /**
     * @param value indicates whether custom window is enabled or disabled
     */
    @JvmName("xjiwtiwsoyirumuu")
    public suspend fun customWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customWindow = mapped
    }

    /**
     * @param value day of week for maintenance window
     */
    @JvmName("nhamiflucfstwwrc")
    public suspend fun dayOfWeek(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value start hour for maintenance window
     */
    @JvmName("fcpwneqkxpnbnkhm")
    public suspend fun startHour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startHour = mapped
    }

    /**
     * @param value start minute for maintenance window
     */
    @JvmName("kkocgwbbejivmsle")
    public suspend fun startMinute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startMinute = mapped
    }

    internal fun build(): MaintenanceWindowArgs = MaintenanceWindowArgs(
        customWindow = customWindow,
        dayOfWeek = dayOfWeek,
        startHour = startHour,
        startMinute = startMinute,
    )
}
