@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an Active Directory administrator.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property objectId The objectId of the Active Directory administrator.
 * @property principalName Active Directory administrator principal name.
 * @property principalType The principal type used to represent the type of Active Directory Administrator.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tenantId The tenantId of the Active Directory administrator.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAdministratorResult(
    public val id: String,
    public val name: String,
    public val objectId: String? = null,
    public val principalName: String? = null,
    public val principalType: String? = null,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.GetAdministratorResult):
            GetAdministratorResult = GetAdministratorResult(
            id = javaType.id(),
            name = javaType.name(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            principalName = javaType.principalName().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
