@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a migration resource.
 * @property cancel To trigger cancel for entire migration we need to send this flag as True
 * @property currentStatus Current status of migration
 * @property dbsToCancelMigrationOn When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
 * @property dbsToMigrate Number of databases to migrate
 * @property dbsToTriggerCutoverOn When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property migrationId ID for migration, a GUID.
 * @property migrationMode There are two types of migration modes Online and Offline
 * @property migrationWindowEndTimeInUtc End time in UTC for migration window
 * @property migrationWindowStartTimeInUtc Start time in UTC for migration window
 * @property name The name of the resource
 * @property overwriteDbsInTarget Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
 * @property setupLogicalReplicationOnSourceDbIfNeeded Indicates whether to setup LogicalReplicationOnSourceDb, if needed
 * @property sourceDbServerFullyQualifiedDomainName Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
 * @property sourceDbServerMetadata Metadata of the source database server
 * @property sourceDbServerResourceId ResourceId of the source database server
 * @property startDataMigration Indicates whether the data migration should start right away
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property targetDbServerFullyQualifiedDomainName Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
 * @property targetDbServerMetadata Metadata of the target database server
 * @property targetDbServerResourceId ResourceId of the source database server
 * @property triggerCutover To trigger cutover for entire migration we need to send this flag as True
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMigrationResult(
    public val cancel: String? = null,
    public val currentStatus: MigrationStatusResponse,
    public val dbsToCancelMigrationOn: List<String>? = null,
    public val dbsToMigrate: List<String>? = null,
    public val dbsToTriggerCutoverOn: List<String>? = null,
    public val id: String,
    public val location: String,
    public val migrationId: String,
    public val migrationMode: String? = null,
    public val migrationWindowEndTimeInUtc: String? = null,
    public val migrationWindowStartTimeInUtc: String? = null,
    public val name: String,
    public val overwriteDbsInTarget: String? = null,
    public val setupLogicalReplicationOnSourceDbIfNeeded: String? = null,
    public val sourceDbServerFullyQualifiedDomainName: String? = null,
    public val sourceDbServerMetadata: DbServerMetadataResponse,
    public val sourceDbServerResourceId: String? = null,
    public val startDataMigration: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetDbServerFullyQualifiedDomainName: String? = null,
    public val targetDbServerMetadata: DbServerMetadataResponse,
    public val targetDbServerResourceId: String,
    public val triggerCutover: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.GetMigrationResult):
            GetMigrationResult = GetMigrationResult(
            cancel = javaType.cancel().map({ args0 -> args0 }).orElse(null),
            currentStatus = javaType.currentStatus().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MigrationStatusResponse.Companion.toKotlin(args0)
            }),
            dbsToCancelMigrationOn = javaType.dbsToCancelMigrationOn().map({ args0 -> args0 }),
            dbsToMigrate = javaType.dbsToMigrate().map({ args0 -> args0 }),
            dbsToTriggerCutoverOn = javaType.dbsToTriggerCutoverOn().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            migrationId = javaType.migrationId(),
            migrationMode = javaType.migrationMode().map({ args0 -> args0 }).orElse(null),
            migrationWindowEndTimeInUtc = javaType.migrationWindowEndTimeInUtc().map({ args0 ->
                args0
            }).orElse(null),
            migrationWindowStartTimeInUtc = javaType.migrationWindowStartTimeInUtc().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            overwriteDbsInTarget = javaType.overwriteDbsInTarget().map({ args0 -> args0 }).orElse(null),
            setupLogicalReplicationOnSourceDbIfNeeded = javaType.setupLogicalReplicationOnSourceDbIfNeeded().map({ args0 ->
                args0
            }).orElse(null),
            sourceDbServerFullyQualifiedDomainName = javaType.sourceDbServerFullyQualifiedDomainName().map({ args0 ->
                args0
            }).orElse(null),
            sourceDbServerMetadata = javaType.sourceDbServerMetadata().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DbServerMetadataResponse.Companion.toKotlin(args0)
            }),
            sourceDbServerResourceId = javaType.sourceDbServerResourceId().map({ args0 -> args0 }).orElse(null),
            startDataMigration = javaType.startDataMigration().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetDbServerFullyQualifiedDomainName = javaType.targetDbServerFullyQualifiedDomainName().map({ args0 ->
                args0
            }).orElse(null),
            targetDbServerMetadata = javaType.targetDbServerMetadata().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DbServerMetadataResponse.Companion.toKotlin(args0)
            }),
            targetDbServerResourceId = javaType.targetDbServerResourceId(),
            triggerCutover = javaType.triggerCutover().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
